/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.builders;

import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import ru.mk.pump.commons.exception.ConfigurationException;
import ru.mk.pump.web.browsers.DriverBuilder;
import ru.mk.pump.web.browsers.builders.BuilderHelper;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.exceptions.BrowserException;

abstract class AbstractDriverBuilder<T extends Capabilities>
implements DriverBuilder {
    private final BuilderHelper builderHelper;
    private final BrowserConfig config;

    public AbstractDriverBuilder(BrowserConfig config, BuilderHelper builderHelper) {
        this.config = config;
        this.builderHelper = builderHelper;
    }

    @Override
    public WebDriver createAndStartDriver() {
        if (this.config.isHeadless() && !this.isHeadlessSupport()) {
            throw new ConfigurationException("Headless mode isn't supported. Disable it in browser config");
        }
        if (this.config.isRemoteDriver()) {
            return this.createRemoteDriver(this.gridUrl(), this.getSpecialCapabilities().merge(this.builderHelper.getCommonCapabilities()));
        }
        this.builderHelper.prepareLocalDriverPath();
        return this.createLocalDriver(this.getSpecialCapabilities().merge(this.builderHelper.getCommonCapabilities()));
    }

    protected WebDriver createRemoteDriver(URL remoteUrl, T allCapabilities) {
        return new RemoteWebDriver(remoteUrl, allCapabilities);
    }

    protected abstract WebDriver createLocalDriver(T var1);

    protected abstract T getSpecialCapabilities();

    private URL gridUrl() {
        try {
            return new URL(this.config.getRemoteDriverUrl());
        }
        catch (MalformedURLException e) {
            throw new BrowserException("Selenium grid URL parsing error " + this.config.getRemoteDriverUrl(), (Throwable)e);
        }
    }

    public BuilderHelper getBuilderHelper() {
        return this.builderHelper;
    }

    @Override
    public BrowserConfig getConfig() {
        return this.config;
    }
}

