/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.builders;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.mk.pump.commons.utils.FileUtils;
import ru.mk.pump.commons.utils.ProjectResources;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.utils.CapabilitiesUtils;

public class BuilderHelper {
    private final BrowserConfig browserConfig;

    public BuilderHelper(BrowserConfig browserConfig) {
        this.browserConfig = browserConfig;
    }

    public void prepareLocalDriverPath() {
        String path = this.getPath();
        if (!Strings.isEmpty((String)path)) {
            System.setProperty("webdriver." + this.browserConfig.getType().getDriverName() + ".driver", path);
        }
    }

    private String getPath() {
        if (FileUtils.isExistsAndValid((String)this.browserConfig.getWebDriverPath())) {
            return this.browserConfig.getWebDriverPath();
        }
        List pathList = ProjectResources.findResourceList((String)this.browserConfig.getType().getDriverName());
        if (!pathList.isEmpty()) {
            return ((Path)pathList.get(0)).toString();
        }
        return Strings.empty();
    }

    public Optional<String> findLocalBrowserPath() {
        return Optional.empty();
    }

    public Capabilities getCommonCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        if (this.browserConfig.isDebug()) {
            capabilities.setCapability("enableVNC", true);
        }
        capabilities.setCapability("acceptSslCerts", true);
        capabilities.setCapability("takesScreenshot", true);
        capabilities.setCapability("ensureCleanSession", true);
        capabilities.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.DISMISS);
        capabilities.setCapability("pageLoadStrategy", "none");
        capabilities.setCapability("nativeEvents", false);
        if (!Strings.isEmpty((String)this.browserConfig.getVersion())) {
            capabilities.setVersion(this.browserConfig.getVersion());
        }
        if (this.browserConfig.getCapabilitiesFile() != null) {
            capabilities.merge(CapabilitiesUtils.loadFromProperties(this.browserConfig.getCapabilitiesFile()));
        }
        return capabilities;
    }
}

