/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.configuration;

import org.openqa.selenium.Dimension;
import ru.mk.pump.commons.config.Property;
import ru.mk.pump.commons.utils.Strings;

public final class Size {
    @Property(value="device", required=false)
    private String deviceName;
    private boolean defaultSize;
    @Property(value="fullscreen", required=false)
    private boolean fullScreen;
    @Property(value="x", required=false)
    private int x;
    @Property(value="y", required=false)
    private int y;

    private Size(int x, int y, boolean fullScreen, String deviceName) {
        this.x = x;
        this.y = y;
        this.fullScreen = fullScreen;
        this.deviceName = deviceName;
        this.defaultSize = !fullScreen && (x < 1 || y < 1);
    }

    public static Size of(int x, int y) {
        return new Size(x, y, false, null);
    }

    public static Size of(boolean fullScreen) {
        return new Size(0, 0, fullScreen, null);
    }

    public boolean useDevice() {
        return !Strings.isEmpty((String)this.deviceName);
    }

    public boolean useSize() {
        return !this.useDevice() && !this.fullScreen && !this.defaultSize;
    }

    public Dimension getDimension() {
        if (this.useSize()) {
            return new Dimension(this.x, this.y);
        }
        String[] size = "1920,1080".split(",");
        return new Dimension(Integer.valueOf(size[0]).intValue(), Integer.valueOf(size[1]).intValue());
    }

    public Size() {
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public boolean isDefaultSize() {
        return this.defaultSize;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

