/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.ExecutionException;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Objects;
import ru.mk.pump.commons.utils.Pre;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.common.api.ItemsManager;
import ru.mk.pump.web.common.api.annotations.PAction;
import ru.mk.pump.web.common.api.annotations.PComponent;
import ru.mk.pump.web.common.api.annotations.PElement;
import ru.mk.pump.web.component.BaseComponent;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.interpretator.items.Item;
import ru.mk.pump.web.interpretator.items.Method;
import ru.mk.pump.web.interpretator.items.TestParameter;
import ru.mk.pump.web.interpretator.rules.Pumpkin;
import ru.mk.pump.web.page.BasePage;
import ru.mk.pump.web.page.api.Page;
import ru.mk.pump.web.utils.TestVars;

public class WebItemsController
implements StrictInfo {
    private static final Logger log = LoggerFactory.getLogger(WebItemsController.class);
    public static final String VAR_LAST_RESULT = "controller_last_result";
    private final Set<BiFunction<Object, WebItemsController, Object>> resultHandlerChain = Sets.newHashSet();
    private static final BiFunction<Object, WebItemsController, Object> DEFAULT_HANDLER = (result, controller) -> {
        log.debug("[CONTROLLER] Result : {}", result);
        return result;
    };
    private final ItemsManager<BasePage> pageManager;
    private final ItemsManager<BaseComponent> componentManager;
    private final Pumpkin pumpkin;
    private final TestVars testVars;
    private Object lastResult;
    private String lastPumpkinExpression;

    public WebItemsController(@NonNull ItemsManager<BasePage> pageManager, @NonNull ItemsManager<BaseComponent> componentManager, @NonNull Pumpkin pumpkin, @NonNull TestVars testVars) {
        if (pageManager == null) {
            throw new NullPointerException("pageManager is marked @NonNull but is null");
        }
        if (componentManager == null) {
            throw new NullPointerException("componentManager is marked @NonNull but is null");
        }
        if (pumpkin == null) {
            throw new NullPointerException("pumpkin is marked @NonNull but is null");
        }
        if (testVars == null) {
            throw new NullPointerException("testVars is marked @NonNull but is null");
        }
        this.pageManager = pageManager;
        this.componentManager = componentManager;
        this.pumpkin = pumpkin;
        this.testVars = testVars;
        this.resultHandlerChain.add(DEFAULT_HANDLER);
    }

    public WebItemsController(@NonNull ItemsManager<BasePage> pageManager, @NonNull ItemsManager<BaseComponent> componentManager, @NonNull TestVars testVars) {
        this(pageManager, componentManager, new Pumpkin(testVars.asMap()), testVars);
        if (pageManager == null) {
            throw new NullPointerException("pageManager is marked @NonNull but is null");
        }
        if (componentManager == null) {
            throw new NullPointerException("componentManager is marked @NonNull but is null");
        }
        if (testVars == null) {
            throw new NullPointerException("testVars is marked @NonNull but is null");
        }
    }

    @NonNull
    public Component initComponent(@NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        Queue<Item> res = this.pumpkin.generateItems(pumpkinExpression);
        if (res.isEmpty()) {
            throw new IllegalArgumentException(String.format("Error pumpkin expression '%s' to creating Component", pumpkinExpression));
        }
        log.info("[CONTROLLER] Try to init current component from '{}'", res);
        return this.componentManager.getOne(WebItemsController.cast(res.poll().getSource(), String.class));
    }

    @NonNull
    public Page initPage(@NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        Queue<Item> res = this.pumpkin.generateItems(pumpkinExpression);
        if (res.isEmpty()) {
            throw new IllegalArgumentException(String.format("Error pumpkin expression '%s' to creating Component", pumpkinExpression));
        }
        log.info("[CONTROLLER] Try to init current page from '{}'", res);
        return this.pageManager.getOne(WebItemsController.cast(res.poll().getSource(), String.class));
    }

    @Nullable
    public Object execute(@NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        return this.execute(null, pumpkinExpression);
    }

    public Object executeOnCurrentPage(@NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        if (this.pageManager.getCurrent() == null) {
            throw new ExecutionException("Current page is undefined. Please, initPage before using").addTarget("controller", (StrictInfo)this);
        }
        return this.execute(this.pageManager.getCurrent(), pumpkinExpression);
    }

    public Object executeOnCurrentComponent(@NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        if (this.componentManager.getCurrent() == null) {
            throw new ExecutionException("Current component is undefined. Please, initComponent before using").addTarget("controller", (StrictInfo)this);
        }
        return this.execute(this.componentManager.getCurrent(), pumpkinExpression);
    }

    @Nullable
    public Object execute(@Nullable Object targetObject, @NonNull String pumpkinExpression) {
        if (pumpkinExpression == null) {
            throw new NullPointerException("pumpkinExpression is marked @NonNull but is null");
        }
        this.lastPumpkinExpression = pumpkinExpression;
        Queue<Item> items = this.pumpkin.generateItems(pumpkinExpression);
        log.info("[CONTROLLER] Executing has started. Items are '{}'", items);
        log.info("[CONTROLLER] Target is present = '{}'", (Object)(targetObject != null ? 1 : 0));
        this.lastResult = this.recurseExecute(targetObject, items);
        log.info("[CONTROLLER] Executing has finished. Result class is '{}'", (Object)this.getClass(this.lastResult));
        return this.walkOnAllHandlers(this.lastResult);
    }

    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"WebItemsController").put("page manager", Strings.toPrettyString((Map)this.pageManager.getInfo())).put("component manager", Strings.toPrettyString((Map)this.componentManager.getInfo())).put("last expression", this.lastPumpkinExpression).put("lastResult", Strings.toString((Object)this.lastResult)).put("test vars", this.testVars.toPrettyString()).build();
    }

    public WebItemsController clearResultHandlers() {
        this.resultHandlerChain.clear();
        this.resultHandlerChain.add(DEFAULT_HANDLER);
        return this;
    }

    public WebItemsController addResultHandler(BiFunction<Object, WebItemsController, Object> handler) {
        this.resultHandlerChain.add(handler);
        return this;
    }

    public Object findField(Object candidate, ru.mk.pump.web.interpretator.items.Field field) {
        Pre.checkObjectNotNull((Object)candidate, Object.class);
        Pre.checkObjectNotNull((Object)field, Method.class);
        if (candidate instanceof Component) {
            if (field.hasIndex()) {
                Object res = this.readField(candidate, field);
                if (!(res instanceof List)) {
                    throw new ExecutionException(String.format("Target object '%s' with field '%s' is not expected class : List. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)field), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this);
                }
                return ((List)res).get(field.getIndex());
            }
            return this.readField(candidate, field);
        }
        throw new ExecutionException(String.format("Target object '%s' with field '%s' is not expected class : Component. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)field), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this);
    }

    public Object callMethod(Object candidate, Method method) {
        Pre.checkObjectNotNull((Object)candidate, Object.class, (String)String.format("Target object with method '%s' cannot be null. Source expression is '%s'", method, this.lastPumpkinExpression));
        Pre.checkObjectNotNull((Object)method, Method.class, (String)String.format("Method desc cannot be null. Source expression is '%s'", this.lastPumpkinExpression));
        if (candidate instanceof Page || candidate instanceof Component || candidate instanceof Element) {
            return this.invoke(candidate, method);
        }
        throw new ExecutionException(String.format("Object '%s' with method '%s' is not expected class : Page or Component or Element. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)method), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this);
    }

    private Object walkOnAllHandlers(Object result) {
        return this.resultHandlerChain.stream().reduce(result, (res, handler) -> handler.apply(res, this), (prev, next) -> next);
    }

    private Object recurseExecute(Object prev, Queue<Item> pumpkinItems) {
        if (pumpkinItems.isEmpty()) {
            return prev;
        }
        Item item = pumpkinItems.poll();
        if (item instanceof TestParameter) {
            return this.recurseExecute(item.getSource(), pumpkinItems);
        }
        if (item instanceof Method) {
            return this.recurseExecute(this.callMethod(prev, (Method)item), pumpkinItems);
        }
        if (item instanceof ru.mk.pump.web.interpretator.items.Field) {
            return this.recurseExecute(this.getField(prev, (ru.mk.pump.web.interpretator.items.Field)item), pumpkinItems);
        }
        throw new UnknownError("It should not have happened");
    }

    private Object getField(Object candidate, ru.mk.pump.web.interpretator.items.Field field) {
        Pre.checkObjectNotNull((Object)field, ru.mk.pump.web.interpretator.items.Field.class);
        if (candidate == null) {
            log.warn("[CONTROLLER] Target page or component is undefined");
            if (!this.pageManager.getList((String)field.getSource()).isEmpty()) {
                log.info("[CONTROLLER] Try to get target page '{}'", field.getSource());
                return this.pageManager.getCurrentList().get(0);
            }
            if (!this.componentManager.getList((String)field.getSource()).isEmpty()) {
                log.info("[CONTROLLER] Try to get target component '{}'", field.getSource());
                Component res = this.componentManager.getCurrentList().get(0);
                res.initAllElements();
                return res;
            }
            throw new ExecutionException(String.format("Target object is 'null' with field '%s'. Source expression is '%s'", Strings.toString((Object)field), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this);
        }
        if (candidate instanceof Component) {
            return this.findField(candidate, field);
        }
        throw new ExecutionException(String.format("Object '%s' with field '%s' is not expected class : Page or Component. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)field), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this);
    }

    private String getClass(Object object) {
        return ClassUtils.getShortClassName((Object)object, (String)"null");
    }

    private Object readField(Object candidate, ru.mk.pump.web.interpretator.items.Field field) {
        Pre.checkObjectNotNull((Object)candidate, Object.class, (String)String.format("Target object with filed '%s' cannot be null . Source expression is '%s'", field, this.lastPumpkinExpression));
        Optional<Field> optionalField = FieldUtils.getFieldsListWithAnnotation(candidate.getClass(), PElement.class).stream().filter(f -> f.getAnnotation(PElement.class).value().equalsIgnoreCase((String)field.getSource()) || f.getName().equalsIgnoreCase((String)field.getSource())).findFirst();
        Field result = !optionalField.isPresent() ? FieldUtils.getFieldsListWithAnnotation(candidate.getClass(), PComponent.class).stream().filter(f -> f.getAnnotation(PComponent.class).value().equalsIgnoreCase((String)field.getSource()) || f.getName().equalsIgnoreCase((String)field.getSource())).findFirst().orElseThrow(() -> new ExecutionException(String.format("Cannot find in object '%s' field '%s'. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)field), this.lastPumpkinExpression)).addTarget("controller", (StrictInfo)this)) : optionalField.get();
        result.setAccessible(true);
        try {
            return result.get(candidate);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(String.format("Execution error in object '%s' field '%s'. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)field), this.lastPumpkinExpression), (Throwable)e).addTarget("controller", (StrictInfo)this);
        }
    }

    private Object invoke(Object candidate, Method method) {
        Pre.checkObjectNotNull((Object)candidate, Object.class);
        java.lang.reflect.Method oneMethod = Arrays.stream(candidate.getClass().getMethods()).filter(m -> {
            if (m.isAnnotationPresent(PAction.class)) {
                return m.getAnnotation(PAction.class).value().equalsIgnoreCase((String)method.getSource()) || m.getName().equalsIgnoreCase((String)method.getSource());
            }
            return m.getName().equalsIgnoreCase((String)method.getSource());
        }).filter(m -> m.getParameterCount() == method.getArgs().length).findFirst().orElseThrow(() -> new ExecutionException(String.format("Cannot find in object '%s' method '%s'", this.getClass(candidate), Strings.toString((Object)method))).addTarget("controller", (StrictInfo)this).addTarget("controller", (StrictInfo)this));
        try {
            oneMethod.setAccessible(true);
            return oneMethod.invoke(candidate, this.castArgs(oneMethod, method.getArgs()));
        }
        catch (Exception e) {
            throw new ExecutionException(String.format("Execution error in object '%s' method '%s'. Source expression is '%s'", this.getClass(candidate), Strings.toString((Object)method), this.lastPumpkinExpression), (Throwable)e).addTarget("controller", (StrictInfo)this);
        }
    }

    private Object[] castArgs(java.lang.reflect.Method method, Object[] args) {
        Object[] newArgs = new Object[args.length];
        Class<?>[] expectedArgs = method.getParameterTypes();
        for (int i = 0; i < expectedArgs.length; ++i) {
            Pre.checkArgListSize((int)i, (int)args.length, (String)String.format("Methods arguments count must be '%s'", expectedArgs.length));
            newArgs[i] = String.class.isAssignableFrom(expectedArgs[i]) || !(args[i] instanceof String) ? args[i] : Strings.toObject((String)String.valueOf(args[i]), expectedArgs[i]);
        }
        return newArgs;
    }

    @NonNull
    public static <T> T cast(@NonNull Object object, @NonNull Class<T> expectedClass) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        if (expectedClass == null) {
            throw new NullPointerException("expectedClass is marked @NonNull but is null");
        }
        return (T)Objects.cast((Object)object, expectedClass);
    }

    public String toString() {
        return "WebItemsController(pageManager=" + this.getPageManager() + ", componentManager=" + this.getComponentManager() + ", testVars=" + (Object)((Object)this.getTestVars()) + ", lastResult=" + this.getLastResult() + ", lastPumpkinExpression=" + this.lastPumpkinExpression + ")";
    }

    public ItemsManager<BasePage> getPageManager() {
        return this.pageManager;
    }

    public ItemsManager<BaseComponent> getComponentManager() {
        return this.componentManager;
    }

    public TestVars getTestVars() {
        return this.testVars;
    }

    public Object getLastResult() {
        return this.lastResult;
    }
}

