/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;
import org.openqa.selenium.WebDriver;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.reporter.ReporterAllure;
import ru.mk.pump.commons.reporter.Screenshoter;
import ru.mk.pump.commons.utils.BrowserScreenshoter;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.web.common.api.WebListenersConfiguration;
import ru.mk.pump.web.configuration.ConfigurationHolder;

@ThreadSafe
public final class WebReporter {
    private static final Function<Supplier<WebDriver>, Screenshoter> DEFAULT_SCREEN = BrowserScreenshoter::new;
    private static ThreadLocal<Reporter> reporter = new InheritableThreadLocal<Reporter>();
    private static ThreadLocal<Verifier> verifier = new InheritableThreadLocal<Verifier>();
    private static WebListenersConfiguration listenersConfiguration;

    public static void init(@NonNull Screenshoter screenshoter, @NonNull ReporterAllure.Type loggerDuplicateLevel) {
        if (screenshoter == null) {
            throw new NullPointerException("screenshoter is marked @NonNull but is null");
        }
        if (loggerDuplicateLevel == null) {
            throw new NullPointerException("loggerDuplicateLevel is marked @NonNull but is null");
        }
        WebReporter.newInstancesAndSave(screenshoter, loggerDuplicateLevel);
    }

    public static void init(@NonNull Supplier<WebDriver> driver) {
        if (driver == null) {
            throw new NullPointerException("driver is marked @NonNull but is null");
        }
        WebReporter.newInstancesAndSave(DEFAULT_SCREEN.apply(driver), WebReporter.get(ConfigurationHolder.get().getReporting().getPostLogbackLevel(), ReporterAllure.Type.ALL));
    }

    public static synchronized void setReporter(Reporter reporter) {
        WebReporter.reporter.set(reporter);
    }

    public static synchronized void setVerifier(Verifier verifier) {
        WebReporter.verifier.set(verifier);
    }

    public static Reporter getReporter() {
        Preconditions.checkNotNull((Object)reporter.get(), (Object)"Initialize before using");
        return reporter.get();
    }

    public static Verifier getVerifier() {
        Preconditions.checkNotNull((Object)verifier.get(), (Object)"Initialize before using");
        return verifier.get();
    }

    private static void newInstancesAndSave(Screenshoter screenshoter, ReporterAllure.Type loggerDuplicateLevel) {
        ReporterAllure reporter = new ReporterAllure(screenshoter, loggerDuplicateLevel);
        reporter.setAutoScreenLevel(WebReporter.get(ConfigurationHolder.get().getReporting().getPostScreenLevel(), ReporterAllure.Type.OFF));
        reporter.setPostingLevel(WebReporter.get(ConfigurationHolder.get().getReporting().getPostLevel(), ReporterAllure.Type.INFO));
        Verifier verifier = new Verifier((Reporter)reporter);
        verifier.setPostPassedCheck(ConfigurationHolder.get().getVerify().isPostPassedCheck());
        verifier.setPostPassedScreen(ConfigurationHolder.get().getVerify().isScreenOnSuccessCheck());
        WebReporter.setReporter((Reporter)reporter);
        WebReporter.setVerifier(verifier);
    }

    private static <T> T get(T object, T defaultIfNull) {
        if (object == null) {
            return defaultIfNull;
        }
        return object;
    }

    private WebReporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static WebListenersConfiguration getListenersConfiguration() {
        return listenersConfiguration;
    }

    public static void setListenersConfiguration(WebListenersConfiguration listenersConfiguration) {
        WebReporter.listenersConfiguration = listenersConfiguration;
    }

    static {
        WebReporter.newInstancesAndSave(Optional::empty, WebReporter.get(ConfigurationHolder.get().getReporting().getPostLogbackLevel(), ReporterAllure.Type.ALL));
    }
}

