/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common.pageobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import org.openqa.selenium.By;
import org.openqa.selenium.support.AbstractFindByBuilder;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.PageFactoryFinder;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public class Annotations
extends AbstractAnnotations {
    private AnnotatedElement annotatedElement;

    public Annotations(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
    }

    public boolean isLookupCached() {
        return this.annotatedElement.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        for (Annotation annotation : this.annotatedElement.getDeclaredAnnotations()) {
            AbstractFindByBuilder builder = null;
            if (annotation.annotationType().isAnnotationPresent(PageFactoryFinder.class)) {
                try {
                    builder = (AbstractFindByBuilder)annotation.annotationType().getAnnotation(PageFactoryFinder.class).value().newInstance();
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (builder == null) continue;
            if (this.getAnnotatedElement() instanceof Field) {
                ans = builder.buildIt((Object)annotation, (Field)this.annotatedElement);
                break;
            }
            ans = builder.buildIt((Object)annotation, null);
            break;
        }
        if (ans == null) {
            ans = this.buildByFromDefault();
        }
        if (ans == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.annotatedElement);
        }
        return ans;
    }

    protected AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    protected By buildByFromDefault() {
        if (this.getAnnotatedElement() instanceof Member) {
            return new ByIdOrName(((Member)((Object)this.annotatedElement)).getName());
        }
        return null;
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.annotatedElement.getAnnotation(FindBys.class);
        FindAll findAll = this.annotatedElement.getAnnotation(FindAll.class);
        FindBy findBy = this.annotatedElement.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBys != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBys' annotation");
        }
    }
}

