/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.component;

import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.common.pageobject.Initializer;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.ElementImplDispatcher;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.page.api.Page;

public class BaseComponent
extends BaseElement
implements Component {
    private static final Logger log = LoggerFactory.getLogger(BaseComponent.class);
    private Initializer initializer;
    private ElementFactory selfComponentFactory;

    public BaseComponent(By avatarBy, Page page) {
        super(avatarBy, page);
    }

    public BaseComponent(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
    }

    public BaseComponent(By avatarBy, Browser browser) {
        super(avatarBy, browser);
    }

    @Override
    public void check() {
        SetState res = this.getInternalStateResolver().resolve(this.ready());
        this.getVerifier().checkTrue(res.name(), res.result().isSuccess(), new String[]{res.toPrettyString()});
    }

    @Override
    public Initializer getInitializer() {
        if (this.initializer == null) {
            this.initializer = new Initializer(this.getSubElementFactory(), this.getComponentFactory(), this);
        }
        return this.initializer;
    }

    @Override
    protected ElementFactory getSubElementFactory() {
        if (this.getPage() != null) {
            return new ElementFactory((PageItemImplDispatcher)new ElementImplDispatcher(), this.getPage());
        }
        return new ElementFactory((PageItemImplDispatcher)new ElementImplDispatcher(), this.getBrowser());
    }

    protected ElementFactory getComponentFactory() {
        if (this.selfComponentFactory == null) {
            this.selfComponentFactory = this.getPage() != null ? new ElementFactory(Component.getImplDispatcher(), this.getPage()) : new ElementFactory(Component.getImplDispatcher(), this.getBrowser());
        }
        return this.selfComponentFactory;
    }
}

