/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.elements.api.listeners.ActionListener;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.internal.ActionNotifier;
import ru.mk.pump.web.elements.internal.StateResolver;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.exceptions.ActionExecutingException;

public class ActionExecutor
extends ActionNotifier {
    private static final Logger log = LoggerFactory.getLogger(ActionExecutor.class);
    private static final int MAX_TRY = 5;
    private final Parameters parameters = Parameters.of();
    private final List<Action> beforeActions = new ArrayList<Action>();
    private final List<Action> afterActions = new ArrayList<Action>();
    private final List<Action> afterActionError = new ArrayList<Action>();
    private final boolean main;
    private int actionExecutionTry = 0;
    private StateResolver stateResolver;

    public ActionExecutor() {
        this(Sets.newHashSet(), true);
    }

    protected ActionExecutor(Set<ActionListener> actionListeners) {
        this(actionListeners, true);
    }

    protected ActionExecutor(Set<ActionListener> actionListeners, boolean main) {
        super(actionListeners);
        this.main = main;
    }

    public ActionExecutor withStateResolver(StateResolver stateResolver) {
        this.stateResolver = stateResolver;
        return this;
    }

    public ActionExecutor clearAllActions() {
        this.beforeActions.clear();
        this.afterActions.clear();
        this.afterActionError.clear();
        return this;
    }

    public ActionExecutor addBefore(Action beforeAction) {
        this.beforeActions.add(beforeAction);
        return this;
    }

    public ActionExecutor addAfter(Action afterAction) {
        this.afterActions.add(afterAction);
        return this;
    }

    public ActionExecutor addAfterError(Action afterActionError) {
        this.afterActionError.add(afterActionError);
        return this;
    }

    public <T> T execute(Action<T> tAction) {
        block10: {
            tAction.setStage(Action.ActionStage.NOT_RUN);
            try {
                if (this.isExcludedStrategy(tAction, ActionStrategy.NO_STATE_CHECK)) {
                    if (tAction.getRedefineState() != null) {
                        tAction.setStage(Action.ActionStage.BEFORE);
                        this.stateResolver.resolve(tAction.getRedefineState()).result().throwExceptionOnFail();
                    } else if (this.stateResolver != null) {
                        tAction.setStage(Action.ActionStage.BEFORE);
                        this.stateResolver.resolve(tAction.getTarget().ready()).result().throwExceptionOnFail();
                    }
                }
                if (!this.main || !ConfigurationHolder.get().getElement().isElementHighlight()) break block10;
                tAction.getTarget().highlight(true);
            }
            catch (Throwable throwable) {
                try {
                    this.notifyOnFail(tAction, throwable);
                    throw new ActionExecutingException(tAction, throwable);
                }
                catch (Throwable throwable2) {
                    if (!this.afterActionError.isEmpty() && this.isExcludedStrategy(tAction, ActionStrategy.SIMPLE, ActionStrategy.NO_FINALLY)) {
                        tAction.setStage(Action.ActionStage.FINALLY);
                        ActionExecutor helperExecutor = new ActionExecutor(this.getActionListeners(), false).withParameters(this.parameters);
                        this.afterActionError.forEach(helperExecutor::payloadExecute);
                        this.notifyOnFinallyStateCheck(tAction);
                    }
                    this.actionExecutionTry = 0;
                    throw throwable2;
                }
            }
        }
        if (!this.afterActionError.isEmpty() && this.isExcludedStrategy(tAction, ActionStrategy.SIMPLE, ActionStrategy.NO_FINALLY)) {
            tAction.setStage(Action.ActionStage.FINALLY);
            ActionExecutor helperExecutor = new ActionExecutor(this.getActionListeners(), false).withParameters(this.parameters);
            this.afterActionError.forEach(helperExecutor::payloadExecute);
            this.notifyOnFinallyStateCheck(tAction);
        }
        this.actionExecutionTry = 0;
        return this.payloadExecute(tAction);
    }

    public ActionExecutor withParameters(Parameters parameters) {
        this.parameters.addAll(parameters);
        return this;
    }

    protected boolean needNewExecution(Action tAction, Throwable throwable) {
        if (throwable instanceof AssertionError || throwable instanceof ActionExecutingException || this.actionExecutionTry >= 5) {
            return false;
        }
        if (throwable instanceof NoSuchElementException || throwable instanceof InvalidElementStateException) {
            return true;
        }
        return true;
    }

    protected <T> T payloadExecute(Action<T> tAction) {
        T result = null;
        tAction.withParameters(this.parameters);
        ++this.actionExecutionTry;
        try {
            ActionExecutor helperExecutor;
            if (!this.beforeActions.isEmpty() && this.isExcludedStrategy(tAction, ActionStrategy.SIMPLE, ActionStrategy.NO_BEFORE)) {
                tAction.setStage(Action.ActionStage.BEFORE);
                helperExecutor = new ActionExecutor(this.getActionListeners(), false).withParameters(this.parameters);
                this.beforeActions.forEach(helperExecutor::payloadExecute);
                this.notifyOnBeforeSuccess(tAction);
            }
            tAction.setStage(Action.ActionStage.MAIN);
            result = tAction.get();
            if (!this.afterActions.isEmpty() && this.isExcludedStrategy(tAction, ActionStrategy.SIMPLE, ActionStrategy.NO_AFTER)) {
                tAction.setStage(Action.ActionStage.AFTER);
                helperExecutor = new ActionExecutor(this.getActionListeners(), false).withParameters(this.parameters);
                this.afterActions.forEach(helperExecutor::payloadExecute);
            }
            tAction.setStage(Action.ActionStage.COMPLETED);
        }
        catch (Throwable throwable) {
            if (this.needNewExecution(tAction, throwable)) {
                ++this.actionExecutionTry;
                return this.payloadExecute(tAction);
            }
            if (tAction.getStage() == Action.ActionStage.AFTER) {
                log.error("Error when execute after actions", throwable);
                this.notifyOnAfterActionFail(tAction);
                tAction.setStage(Action.ActionStage.COMPLETED);
            }
            this.notifyOnFail(tAction, throwable);
            if (this.main && ConfigurationHolder.get().getElement().isElementHighlight()) {
                tAction.getTarget().highlight(false);
            }
            throw new ActionExecutingException(tAction, throwable).addTarget("action", tAction);
        }
        this.notifyOnSuccess(tAction, result);
        if (this.main && ConfigurationHolder.get().getElement().isElementHighlight()) {
            tAction.getTarget().highlight(false);
        }
        return result;
    }

    private boolean isExcludedStrategy(Action<?> action, ActionStrategy ... strategies) {
        return action.getStrategy().isEmpty() || action.getStrategy().stream().anyMatch(i -> i.equals((Object)ActionStrategy.STANDARD)) || Arrays.stream(strategies).noneMatch(item -> action.getStrategy().stream().anyMatch(strategy -> strategy.equals(item)));
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public boolean isMain() {
        return this.main;
    }

    public StateResolver getStateResolver() {
        return this.stateResolver;
    }
}

