/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.configuration.Configuration;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.elements.api.listeners.ActionListener;
import ru.mk.pump.web.elements.api.listeners.StateListener;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;

class BaseElementHelper {
    private static final Logger log = LoggerFactory.getLogger(BaseElementHelper.class);
    private final BaseElement baseElement;
    private final Configuration fwConfig;

    BaseElementHelper(BaseElement baseElement) {
        this.baseElement = baseElement;
        this.fwConfig = ConfigurationHolder.get();
    }

    BaseElementHelper windowSizeCheckerEnable() {
        if (this.fwConfig.getElement().getWindowWidthOffset() >= 0) {
            this.baseElement.addStateListener((List)Collections.singletonList(this.newWindowSizeCheckerStateListener()));
        }
        return this;
    }

    public void stateActionReportingEnable() {
        if (this.fwConfig.getElement().isStateReporting()) {
            this.baseElement.getActionExecutor().getStateResolver().addListener(this.newActionStateReporterListener());
        }
    }

    public void stateReportingEnable() {
        if (this.fwConfig.getElement().isStateReporting()) {
            this.baseElement.getStateResolver().addListener(this.newStateReporterListener());
        }
    }

    public void actionsReportingEnable() {
        if (this.fwConfig.getElement().isActionReporting()) {
            this.baseElement.getActionExecutor().addListener(this.newActionReporterListener());
        }
    }

    private ActionListener newActionReporterListener() {
        return new ActionListener(){

            @Override
            public void onAfterActionFail(Action action, Throwable throwable) {
                PumpMessage msg = new PumpMessage("After action was failed").withPre("Action reporting message").addExtraInfo((StrictInfo)action);
                BaseElementHelper.this.baseElement.getReporter().warn(Strings.space((String[])new String[]{"Action", action.name(), "in stage", action.getStage().name()}), msg.toPrettyString(), throwable);
            }

            @Override
            public void onFinallyStateCheck(Action action) {
                this.info("After stage check finally block", action, null);
            }

            @Override
            public void onFail(Action action, Throwable throwable) {
                PumpMessage msg = new PumpMessage("Any stage was failed").withPre("Action reporting message").addExtraInfo((StrictInfo)action);
                BaseElementHelper.this.baseElement.getReporter().warn(Strings.space((String[])new String[]{"Action", action.name(), "in stage", action.getStage().name()}), msg.toPrettyString(), throwable);
            }

            @Override
            public void onSuccess(Action action, Object result) {
                PumpMessage msg = new PumpMessage("All actions is success. Final").withPre("Action reporting message").addExtraInfo((StrictInfo)action);
                BaseElementHelper.this.baseElement.getReporter().info(Strings.space((String[])new String[]{"Action", action.name(), "in stage", action.getStage().name()}), msg.toPrettyString(), BaseElementHelper.this.baseElement.getReporter().attachments().text("RESULT", Strings.toString((Object)result)));
            }

            @Override
            public void onBeforeActionSuccess(Action action) {
                PumpMessage msg = new PumpMessage("Before action is success").withPre("Action reporting message").addExtraInfo((StrictInfo)action);
                BaseElementHelper.this.baseElement.getReporter().debug(Strings.space((String[])new String[]{"Action", action.name(), "in stage", action.getStage().name()}), msg.toPrettyString());
            }

            private void info(String title, Action action, Object result) {
                PumpMessage msg = new PumpMessage(title).withDesc(Strings.toString((Object)result)).withPre("Action reporting message").addExtraInfo((StrictInfo)action);
                BaseElementHelper.this.baseElement.getReporter().info(Strings.space((String[])new String[]{"Action", action.name(), "in stage", action.getStage().name()}), msg.toPrettyString());
            }
        };
    }

    private StateListener newActionStateReporterListener() {
        return new StateListener(){

            @Override
            public void onBefore(Pair<State, InternalElement> args) {
                if (ConfigurationHolder.get().getElement().isElementHighlight()) {
                    ((InternalElement)args.getValue()).highlight(true);
                }
            }

            @Override
            public void onFinish(Pair<State, InternalElement> args) {
                PumpMessage msg = new PumpMessage(String.format("Checking state '%s' of element '%s' is finished in '%d' ms with result '%s'", ((State)args.getKey()).name(), ((InternalElement)args.getValue()).getName(), ((State)args.getKey()).result().getElapsedTime(), ((State)args.getKey()).result().isSuccess())).withPre("State reporting message").addExtraInfo((StrictInfo)args.getKey()).addExtraInfo((StrictInfo)args.getValue());
                if (((State)args.getKey()).result().isSuccess()) {
                    if (((State)args.getKey()).type() == StateType.READY) {
                        BaseElementHelper.this.baseElement.getReporter().debug(msg.getTitle(), msg.toPrettyString());
                    }
                } else {
                    BaseElementHelper.this.baseElement.getReporter().warn(msg.getTitle(), msg.toPrettyString());
                }
            }
        };
    }

    private StateListener newStateReporterListener() {
        return new StateListener(){

            @Override
            public void onBefore(Pair<State, InternalElement> args) {
                if (((State)args.getKey()).type() == StateType.DISPLAYED || ((State)args.getKey()).type() == StateType.SELECTED && ConfigurationHolder.get().getElement().isElementHighlight()) {
                    ((InternalElement)args.getValue()).highlight(true);
                }
                log.trace("Call StateListener#onBeforeActionSuccess from newStateReporterListener()");
            }

            @Override
            public void onFinish(Pair<State, InternalElement> args) {
                PumpMessage msg = new PumpMessage(String.format("Checking state '%s' of element '%s' is finished in '%d' ms with result '%s'", ((State)args.getKey()).name(), ((InternalElement)args.getValue()).getName(), ((State)args.getKey()).result().getElapsedTime(), ((State)args.getKey()).result().isSuccess())).withPre("State reporting message").addExtraInfo((StrictInfo)args.getKey()).addExtraInfo((StrictInfo)args.getValue());
                if (((State)args.getKey()).result().isSuccess()) {
                    BaseElementHelper.this.baseElement.getReporter().info(msg.getTitle(), msg.toPrettyString());
                } else {
                    BaseElementHelper.this.baseElement.getReporter().warn(msg.getTitle(), msg.toPrettyString());
                }
                if (ConfigurationHolder.get().getElement().isElementHighlight()) {
                    ((InternalElement)args.getValue()).highlight(false);
                }
            }
        };
    }

    private StateListener newWindowSizeCheckerStateListener() {
        return new StateListener(){

            @Override
            public void onBefore(Pair<State, InternalElement> args) {
                log.trace("Call StateListener#onBeforeActionSuccess from newWindowSizeCheckerStateListener()");
            }

            @Override
            public void onFinish(Pair<State, InternalElement> args) {
                if (((State)args.getKey()).type() == StateType.DISPLAYED && ((State)args.getKey()).result().isSuccess()) {
                    try {
                        int winWidth = BaseElementHelper.this.baseElement.getBrowser().actions().getSize().getWidth();
                        WebElement avatar = (WebElement)BaseElementHelper.this.baseElement.getFinder().findFast().throwExceptionOnFail().getResult();
                        int elementWidthPosition = avatar.getLocation().getX() + avatar.getSize().getWidth();
                        BaseElementHelper.this.baseElement.getVerifier().checkTrue(String.format("Element size fit the window size. Window width : '%s'. Element position : '%s'", winWidth, elementWidthPosition), winWidth >= elementWidthPosition - BaseElementHelper.this.fwConfig.getElement().getWindowWidthOffset(), new String[0]);
                    }
                    catch (Exception ex) {
                        log.error("Cannot check element position in window. Element is '%s'", (Object)BaseElementHelper.this.baseElement.toString());
                    }
                }
            }
        };
    }
}

