/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matchers;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.commons.utils.Waiter;
import ru.mk.pump.web.elements.internal.FindStrategy;
import ru.mk.pump.web.elements.internal.SingleElementStrategy;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementFinderException;

public class Finder
implements StrictInfo {
    private static final Logger log = LoggerFactory.getLogger(Finder.class);
    public static final int FIND_TIMEOUT_S = 1;
    private final InternalElement mainElement;
    private long logReturnCacheAmount = 0L;
    private long logFindSelfAmount = 0L;
    private long logFindAmount = 0L;
    private WaitResult<WebElement> lastResult;
    private WebElement cache = null;
    private FindStrategy DEFAULT_FIND_STRATEGY;
    private FindStrategy findStrategy;

    Finder(InternalElement mainElement) {
        this.mainElement = mainElement;
        this.findStrategy = new SingleElementStrategy(this.getMainElement());
    }

    public Finder setFindStrategy(FindStrategy findStrategy) {
        this.findStrategy = findStrategy;
        return this;
    }

    Optional<WaitResult<WebElement>> getLast() {
        return Optional.ofNullable(this.lastResult);
    }

    WebElement get() {
        if (!this.getCache().isPresent()) {
            ++this.logFindSelfAmount;
            log.debug("Call findSelf() from Finder.get() '{}'", (Object)this.toString());
            return this.findStrategy.findSelf();
        }
        ++this.logReturnCacheAmount;
        log.debug("Get cache from Finder.get() '{}'", (Object)this.cache);
        return this.cache;
    }

    public WaitResult<WebElement> findFast() {
        ++this.logFindAmount;
        log.debug("Call Finder.findFast() '{}'" + this.toString());
        try {
            WebElement result = this.get();
            this.lastResult = result != null ? new WaitResult(true, 0L).withResult((Object)result) : new WaitResult(false, 0L);
        }
        catch (NotFoundException | ElementFinderException ex) {
            this.lastResult = new WaitResult(false, 0L).withCause((Throwable)ex);
        }
        return this.lastResult;
    }

    public WaitResult<WebElement> find() {
        ++this.logFindAmount;
        log.debug("Call Finder.find() '{}'" + this.toString());
        this.setCache(null);
        this.lastResult = new Waiter().withNotIgnoreExceptions(ElementFinderException.class).withNotIgnoreExceptions(NotFoundException.class).waitIgnoreExceptions(1, 0, this::get, Matchers.notNullValue(WebElement.class));
        return this.lastResult;
    }

    public Finder clearCache() {
        this.cache = null;
        return this;
    }

    Optional<WebElement> getCache() {
        return Optional.ofNullable(this.cache);
    }

    Finder setCache(WebElement targetElement) {
        this.cache = targetElement;
        return this;
    }

    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"Finder").put("main element", this.mainElement.toString()).put("cached result", this.lastResult.toString()).put("find strategy", this.findStrategy.getClass().getSimpleName()).put("logFindAmount", Strings.toString((Object)this.logFindAmount)).put("logFindSelfAmount", Strings.toString((Object)this.logFindSelfAmount)).put("logReturnCacheAmount", Strings.toString((Object)this.logReturnCacheAmount)).build();
    }

    public String toString() {
        return "Finder(logReturnCacheAmount=" + this.logReturnCacheAmount + ", logFindSelfAmount=" + this.logFindSelfAmount + ", logFindAmount=" + this.logFindAmount + ", findStrategy=" + this.findStrategy + ")";
    }

    public InternalElement getMainElement() {
        return this.mainElement;
    }
}

