/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.Collection;
import java.util.List;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.elements.internal.FindStrategy;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementFinderException;
import ru.mk.pump.web.exceptions.ElementFinderNotFoundException;

class ListElementStrategy
extends FindStrategy {
    private static final Logger log = LoggerFactory.getLogger(ListElementStrategy.class);

    public ListElementStrategy(InternalElement target) {
        super(target);
    }

    @Override
    public WebElement findSelf() {
        if (!this.getTarget().isList()) {
            throw new ElementFinderException(String.format("Selected find strategy '%s' don't work with no list rules", this.getClass().getSimpleName())).withTargetElement(this.getTarget());
        }
        if (this.isRoot()) {
            return this.getFromRoot();
        }
        return this.getFromList(this.getList());
    }

    protected WebElement getFromRoot() {
        try {
            if (ConfigurationHolder.get().getElement().isFrameSupport()) {
                this.getTarget().getBrowser().actions().switchToRootFrame();
            }
            List webElements = this.getTarget().getBrowser().getDriver().findElements(this.getTarget().getBy());
            WebElement res = this.getFromList(webElements);
            this.getTarget().getFinder().setCache(res);
            return res;
        }
        catch (WebDriverException ex) {
            this.getTarget().getFinder().setCache(null);
            throw new ElementFinderNotFoundException("Find root element error", (Throwable)ex).withTargetElement(this.getTarget());
        }
    }

    protected List<WebElement> getList() {
        try {
            log.debug("Try to findElements for {}", (Object)this.getTarget());
            List webElements = this.getTarget().getParent().orElseThrow(() -> new ElementFinderNotFoundException("Cannot find parent element").withTargetElement(this.getTarget())).getFinder().get().findElements(this.getTarget().getBy());
            log.debug("Result getList() : " + Strings.toPrettyString((Collection)webElements));
            return webElements;
        }
        catch (StaleElementReferenceException ex) {
            this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            throw ex;
        }
        catch (NotFoundException ex) {
            if (ConfigurationHolder.get().getElement().isFrameSupport()) {
                this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            }
            throw ex;
        }
        catch (WebDriverException ex) {
            this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            throw ex;
        }
    }

    protected WebElement getFromList(List<WebElement> webElements) {
        if (webElements.size() <= this.getTarget().getIndex()) {
            throw new ElementFinderNotFoundException(String.format("Expected element index '%s' is exceeds the list size '%s'", this.getTarget().getIndex(), webElements.size())).withTargetElement(this.getTarget()).withTargetInfo("finder strategy", this);
        }
        try {
            WebElement res = webElements.get(this.getTarget().getIndex());
            this.getTarget().getFinder().setCache(res);
            return res;
        }
        catch (WebDriverException ex) {
            this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            throw ex;
        }
    }
}

