/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.page;

import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.openqa.selenium.support.FindBy;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.CallableExt;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.common.WebReporter;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.common.api.WebListenersConfiguration;
import ru.mk.pump.web.common.api.annotations.PElement;
import ru.mk.pump.web.common.pageobject.Initializer;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.ElementImplDispatcher;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.page.PageLoaderPump;
import ru.mk.pump.web.page.PageNotifier;
import ru.mk.pump.web.page.api.Page;
import ru.mk.pump.web.page.api.PageListener;
import ru.mk.pump.web.page.api.PageLoader;
import ru.mk.pump.web.utils.UrlUtils;

public class BasePage
extends PageNotifier
implements Page {
    @PElement(value="\u0422\u0435\u043b\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b")
    @FindBy(tagName="body")
    private Element pageBody;
    private String baseUrl;
    private String resourcePath;
    private final Browser browser;
    private Reporter reporter;
    private String name = Strings.empty();
    private String description = "undefined";
    private String[] extraUrls;
    private String url;
    private Initializer initializer;
    private PageLoader pageLoader;

    public BasePage(@NonNull Browser browser) {
        if (browser == null) {
            throw new NullPointerException("browser is marked @NonNull but is null");
        }
        this.browser = browser;
        this.afterConstruct();
    }

    public BasePage(@NonNull Browser browser, Reporter reporter) {
        if (browser == null) {
            throw new NullPointerException("browser is marked @NonNull but is null");
        }
        this.browser = browser;
        this.reporter = reporter;
        this.afterConstruct();
    }

    public Reporter getReporter() {
        if (this.reporter == null) {
            this.reporter = WebReporter.getReporter();
        }
        return this.reporter;
    }

    protected void afterConstruct() {
        this.initAllElements();
        this.getPageLoader().addAdditionalCondition((CallableExt<Boolean>)CallableExt.of(this::jsReady).withDescription("Waiting js on page"));
        this.getPageLoader().addDisplayedElements(this.pageBody);
        this.getTitle().ifPresent(el -> this.getPageLoader().addTextContainsElement((Element)el, this.getName()));
        this.addListener(this.newDefaultListener());
        WebListenersConfiguration configuration = WebReporter.getListenersConfiguration();
        if (configuration != null) {
            if (configuration.erasePageListener()) {
                this.clearListeners();
            }
            this.addListeners(configuration.getPageListener(this));
        }
    }

    protected void afterOpen() {
        this.check();
    }

    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"page").put("name", this.name).put("url", this.url).put("browser", this.browser.getId()).build();
    }

    @Override
    public Initializer getInitializer() {
        if (this.initializer == null) {
            this.initializer = new Initializer(new ElementFactory((PageItemImplDispatcher)new ElementImplDispatcher(), this), new ElementFactory(Component.getImplDispatcher(), this));
        }
        return this.initializer;
    }

    @Override
    public String getText() {
        return this.pageBody.getText();
    }

    @Override
    public String getUrl() {
        if (UrlUtils.isUrl(this.url)) {
            return this.url;
        }
        if (this.getBaseUrl() != null) {
            return UrlUtils.concatWithPath(this.getBaseUrl(), this.getResourcePath());
        }
        return Strings.empty();
    }

    @Override
    public void open() {
        this.notifyOnBeforeLoad(this);
        try {
            this.getBrowser().open(this.getUrl());
        }
        catch (Throwable throwable) {
            this.notifyOnLoadFail(this, throwable);
            throw throwable;
        }
        this.notifyOnLoadSuccess(this);
    }

    protected boolean jsReady() {
        String js = "return document.readyState";
        return "complete".equals(Strings.toString((Object)this.getBrowser().actions().executeScript("return document.readyState")));
    }

    @Override
    public Optional<Element> getTitle() {
        return Optional.empty();
    }

    @Override
    public PageLoader getPageLoader() {
        if (this.pageLoader == null) {
            this.pageLoader = WebReporter.getReporter() == this.getReporter() ? new PageLoaderPump(this, WebReporter.getVerifier()) : new PageLoaderPump(this, new Verifier(this.getReporter()));
        }
        return this.pageLoader;
    }

    private PageListener newDefaultListener() {
        return new PageListener(){

            @Override
            public void onLoadSuccess(Page page) {
                BasePage.this.getReporter().info(String.format("Page '%s' load success", BasePage.this.name), page.toString(), BasePage.this.getReporter().attachments().dummy());
            }

            @Override
            public void onLoadFail(Page page, Throwable fromArgsOrNull) {
                BasePage.this.getReporter().warn(String.format("Page '%s' load failed", BasePage.this.name), page.toString(), fromArgsOrNull);
            }

            @Override
            public void onBeforeLoad(Page page) {
                BasePage.this.getReporter().info(String.format("Page '%s' is opening", BasePage.this.name), page.toString(), BasePage.this.getReporter().attachments().dummy());
            }
        };
    }

    @Override
    public void check() {
        this.getPageLoader().checkAdditionalCondition();
        this.getPageLoader().checkElements();
        this.getPageLoader().checkUrl();
    }

    public String toString() {
        return "BasePage(baseUrl=" + this.getBaseUrl() + ", resourcePath=" + this.getResourcePath() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", url=" + this.getUrl() + ")";
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    String[] getExtraUrls() {
        return this.extraUrls;
    }

    void setExtraUrls(String[] extraUrls) {
        this.extraUrls = extraUrls;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public void setPageLoader(PageLoader pageLoader) {
        this.pageLoader = pageLoader;
    }
}

