/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers;

import io.appium.java_client.MobileDriver;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.touch.offset.PointOption;
import io.qameta.allure.Step;
import java.util.function.Supplier;
import lombok.NonNull;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.commons.utils.Waiter;
import ru.mk.pump.web.exceptions.BrowserException;

public class BrowserActions {
    private static final Logger log = LoggerFactory.getLogger(BrowserActions.class);
    private final Supplier<WebDriver> driver;

    BrowserActions(@NonNull Supplier<WebDriver> driverSupplier) {
        if (driverSupplier == null) {
            throw new NullPointerException("driverSupplier is marked @NonNull but is null");
        }
        this.driver = driverSupplier;
    }

    public Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.driver.get()).executeScript(script, args);
    }

    @Deprecated
    public void mobileScroll(int startX, int startY, int stopX, int stopY) {
        TouchAction action = new TouchAction((PerformsTouchActions)((AndroidDriver)this.driver.get()));
        action.longPress(PointOption.point((int)startX, (int)startY)).moveTo(PointOption.point((int)stopX, (int)stopY)).release().perform();
    }

    @Deprecated
    public void mobileScrollDown() {
        MobileDriver mobile = (MobileDriver)this.driver.get();
        int startX = (int)((double)mobile.manage().window().getSize().getWidth() * 0.1);
        int startY = (int)((double)mobile.manage().window().getSize().getHeight() * 0.8);
        int stopX = 1;
        int stopY = 1;
        this.mobileScroll(startX, startY, stopX, stopY);
    }

    public void mobileScroll(PointOption startPoint, PointOption stopPoint) {
        TouchAction action = new TouchAction((PerformsTouchActions)((AndroidDriver)this.driver.get()));
        action.longPress(startPoint).moveTo(stopPoint).release().perform();
    }

    public Object executeScript(String script) {
        return ((JavascriptExecutor)this.driver.get()).executeScript(script, new Object[0]);
    }

    public Dimension getSize() {
        return this.driver.get().manage().window().getSize();
    }

    public String getText(WebElement element) {
        String result = "";
        Exception ex = null;
        try {
            result = element.getText();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        try {
            result = element.getAttribute("value");
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        try {
            result = element.getAttribute("innerText");
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        if (ex != null) {
            log.error("Cannot get text from element : " + element.toString(), (Throwable)ex);
        }
        return result;
    }

    public String getCurrentUrl() {
        return this.driver.get().getCurrentUrl();
    }

    public void switchToRootFrame() {
        this.driver.get().switchTo().defaultContent();
    }

    public void switchToFrame(WebElement element) {
        this.driver.get().switchTo().frame(element);
    }

    public void switchToFrame(int index) {
        this.driver.get().switchTo().frame(index);
    }

    @Step(value="Try to get alert in '{timeout}'")
    public Alert alert(int timeoutS) {
        Waiter waiter = new Waiter();
        WaitResult result = waiter.waitIgnoreExceptions(10, 100, () -> this.driver.get().switchTo().alert() != null);
        result.throwExceptionOnFail(res -> new BrowserException(String.format("Waiting of alert has failed in '%s'", res.getTimeout()), res.getCause()));
        return this.driver.get().switchTo().alert();
    }
}

