/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers;

import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.History;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.AbstractBrowser;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.DriverBuilder;
import ru.mk.pump.web.browsers.builders.AndroidAppDriverBuilder;
import ru.mk.pump.web.browsers.builders.ChromeDriverBuilder;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.browsers.configuration.BrowserType;
import ru.mk.pump.web.exceptions.BrowserException;
import ru.mk.pump.web.utils.WebReporter;

public class Browsers
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Browsers.class);
    private final ThreadLocal<Browser> currentBrowser = new InheritableThreadLocal<Browser>();
    private final ThreadLocal<History<Browser>> browserHistory;
    private Set<Browser> internalAllBrowsers = new CopyOnWriteArraySet<Browser>();

    public Browsers() {
        this.browserHistory = InheritableThreadLocal.withInitial(() -> new History(100));
    }

    public Deque<Browser> getStartedBrowsers() {
        return Queues.newArrayDeque((Iterable)this.getBrowsers().asList().stream().map(History.Info::getPayload).filter(Browser::isStarted).collect(Collectors.toList()));
    }

    public Browser setBrowser(Browser browser) {
        this.checkClosed();
        this.internalAllBrowsers.add(browser);
        this.currentBrowser.set(browser);
        this.browserHistory.get().add(History.Info.of((String)browser.getId(), (Object)browser));
        WebReporter.init(browser);
        return browser;
    }

    public Browser newBrowser(BrowserConfig browserConfig) {
        this.checkClosed();
        AbstractBrowser newBrowser = new AbstractBrowser(Browsers.getBuilder(browserConfig), UUID.randomUUID().toString()){};
        if (browserConfig.getType() == BrowserType.ANDROID_APP) {
            ((Observable)((Object)newBrowser)).deleteObserver((Observer)((Object)newBrowser.windows()));
        }
        this.internalAllBrowsers.add(newBrowser);
        this.currentBrowser.set(newBrowser);
        this.browserHistory.get().add(History.Info.of((String)newBrowser.getId(), (Object)newBrowser));
        WebReporter.init(newBrowser);
        return newBrowser;
    }

    public Browser get() {
        if (this.has()) {
            return this.currentBrowser.get();
        }
        throw new BrowserException("No one active browser in this thread");
    }

    public boolean has() {
        this.checkClosed();
        return this.currentBrowser.get() != null;
    }

    public History<Browser> getBrowsers() {
        return this.browserHistory.get();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.internalAllBrowsers.forEach(Browser::close);
            this.internalAllBrowsers = null;
        }
    }

    public boolean isClosed() {
        return this.internalAllBrowsers == null;
    }

    public void closeCurrentThread() {
        if (!this.isClosed()) {
            this.getBrowsers().getAll().forEach(browser -> ((Browser)browser.getPayload()).close());
            this.currentBrowser.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Browsers{");
        if (this.currentBrowser.get() != null) {
            sb.append("currentBrowser=").append(this.currentBrowser.get().getId());
        }
        if (this.browserHistory.get() != null) {
            sb.append("browserHistory=").append(Strings.toString(this.browserHistory));
        }
        sb.append(", internalAllBrowsers=").append(this.internalAllBrowsers);
        sb.append('}');
        return sb.toString();
    }

    private static DriverBuilder getBuilder(BrowserConfig browserConfig) {
        switch (browserConfig.getType()) {
            case CHROME: {
                return new ChromeDriverBuilder(browserConfig);
            }
            case ANDROID_APP: {
                return new AndroidAppDriverBuilder(browserConfig);
            }
            case FIREFOX: {
                throw new UnsupportedOperationException();
            }
            case IE: {
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("The Object was already closed. Or never had activated");
        }
    }
}

