/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers;

import java.util.Observer;
import java.util.Set;
import lombok.NonNull;
import org.openqa.selenium.Dimension;
import ru.mk.pump.commons.activity.AbstractActivityManager;
import ru.mk.pump.commons.activity.Activity;
import ru.mk.pump.commons.activity.NamedEvent;
import ru.mk.pump.web.browsers.AbstractBrowser;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.Window;
import ru.mk.pump.web.exceptions.BrowserException;

public class WindowManager
extends AbstractActivityManager {
    private Browser browser;

    protected WindowManager(@NonNull AbstractBrowser browser) {
        if (browser == null) {
            throw new NullPointerException("browser is marked @NonNull but is null");
        }
        this.browser = browser;
        this.setFilterActivityClass(new Class[]{Window.class});
        this.add((Activity)browser);
    }

    public WindowManager setSize(Dimension dimension) {
        this.browser.getDriver().manage().window().setSize(dimension);
        return this;
    }

    public WindowManager mazimize() {
        this.browser.getDriver().manage().window().maximize();
        return this;
    }

    public Window newTab() {
        Set windows = this.browser.getDriver().getWindowHandles();
        this.browser.actions().executeScript("window.open()");
        Set newWindows = this.browser.getDriver().getWindowHandles();
        newWindows.removeAll(windows);
        if (newWindows.size() == 0) {
            throw new BrowserException("Cannot create new Tab by JS");
        }
        Window window = Window.of((Observer)((Object)this), this.browser.getDriver(), (String)newWindows.iterator().next());
        this.addAndActivate((Activity)window);
        return window;
    }

    public void onClose(NamedEvent namedEvent, Activity activity) {
        super.onClose(namedEvent, activity);
        if (this.isTargetActivity(activity)) {
            if (this.getActive().isPresent()) {
                ((Activity)this.getActive().get()).activate();
            } else if (this.getPrev().isPresent()) {
                ((Activity)this.getPrev().get()).activate();
            }
        }
    }

    public void onActivate(NamedEvent namedEvent, Activity activity) {
        if (activity instanceof AbstractBrowser) {
            this.addAndActivate((Activity)Window.of((Observer)((Object)this), this.browser.getDriver(), this.browser.getDriver().getWindowHandle()));
        } else {
            super.onActivate(namedEvent, activity);
        }
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }
}

