/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.builders;

import io.appium.java_client.android.AndroidDriver;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.builders.AbstractDriverBuilder;
import ru.mk.pump.web.browsers.builders.BuilderHelper;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;

public class AndroidAppDriverBuilder
extends AbstractDriverBuilder<DesiredCapabilities> {
    public AndroidAppDriverBuilder(BrowserConfig browserConfig) {
        super(browserConfig, new BuilderHelper(browserConfig));
    }

    @Override
    protected WebDriver createLocalDriver(DesiredCapabilities caps) {
        throw new IllegalStateException("Cannot create local android driver. You must enable browser.remote and define browser.remote.url");
    }

    @Override
    protected WebDriver createRemoteDriver(URL remoteUrl, DesiredCapabilities allCapabilities) {
        return new AndroidDriver(remoteUrl, (Capabilities)allCapabilities);
    }

    @Override
    protected DesiredCapabilities getSpecialCapabilities() {
        return this.getAndroidAppCapabilities();
    }

    private DesiredCapabilities getAndroidAppCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("platformName", "Android");
        capabilities.setCapability("platformVersion", this.getConfig().getAppiumPlatformVersion());
        capabilities.setCapability("deviceName", this.getConfig().getAppiumDeviceName());
        if (!Strings.isEmpty((String)this.getConfig().getAppiumAppActivity())) {
            capabilities.setCapability("appActivity", this.getConfig().getAppiumAppActivity());
        }
        if (!Strings.isEmpty((String)this.getConfig().getAppiumAppPackage())) {
            capabilities.setCapability("appPackage", this.getConfig().getAppiumAppPackage());
        }
        if (!Strings.isEmpty((String)this.getConfig().getAppiumApp())) {
            capabilities.setCapability("app", this.getConfig().getAppiumApp());
        }
        return capabilities;
    }

    private String getSize() {
        return this.getConfig().getSizeOrDevice().getX() + "," + this.getConfig().getSizeOrDevice().getY();
    }
}

