/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.builders;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import ru.mk.pump.commons.constants.MainConstants;
import ru.mk.pump.commons.utils.FileUtils;
import ru.mk.pump.web.browsers.builders.AbstractDriverBuilder;
import ru.mk.pump.web.browsers.builders.BuilderHelper;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;

public class ChromeDriverBuilder
extends AbstractDriverBuilder<ChromeOptions> {
    public ChromeDriverBuilder(BrowserConfig browserConfig) {
        super(browserConfig, new BuilderHelper(browserConfig));
    }

    @Override
    protected WebDriver createLocalDriver(ChromeOptions chromeOptions) {
        return new ChromeDriver(chromeOptions);
    }

    @Override
    protected ChromeOptions getSpecialCapabilities() {
        return this.getChromeOptions();
    }

    private ChromeOptions getChromeOptions() {
        ChromeOptions chromeOptions = new ChromeOptions();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"profile.default_content_settings.popups", (Object)0).put((Object)"profile.content_settings.exceptions.automatic_downloads.*.setting", (Object)1).put((Object)"download.prompt_for_download", (Object)"false");
        if (Objects.nonNull(this.getConfig().getDownloadDirPath())) {
            Path path = Paths.get(MainConstants.HOME, new String[0]).resolve(this.getConfig().getDownloadDirPath());
            FileUtils.createIfNotExists((Path)path);
            builder.put((Object)"download.default_directory", (Object)path.toString());
        }
        if (Objects.nonNull(this.getConfig().getBrowserBinPath()) && FileUtils.isExistsAndValid((String)this.getConfig().getBrowserBinPath())) {
            chromeOptions.setBinary(this.getConfig().getBrowserBinPath());
        }
        chromeOptions.addArguments(new String[]{"no-sandbox"});
        chromeOptions.addArguments(new String[]{"chrome.switches", "--disable-extensions"});
        chromeOptions.setExperimentalOption("useAutomationExtension", (Object)false);
        chromeOptions.addArguments(new String[]{"-incognito"});
        chromeOptions.addArguments(new String[]{"test-type"});
        chromeOptions.addArguments(new String[]{"--enable-automation"});
        chromeOptions.addArguments(new String[]{"test-type=browser"});
        chromeOptions.addArguments(new String[]{"disable-infobars"});
        chromeOptions.addArguments(new String[]{"--disable-popup-blocking"});
        chromeOptions.setExperimentalOption("prefs", (Object)builder.build());
        chromeOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        this.getBuilderHelper().findLocalBrowserPath().ifPresent(arg_0 -> ((ChromeOptions)chromeOptions).setBinary(arg_0));
        if (this.getConfig().getSizeOrDevice().useSize()) {
            chromeOptions.addArguments(new String[]{"window-size=" + this.getSize(), "--no-sandbox"});
        } else if (this.getConfig().getSizeOrDevice().isFullScreen()) {
            if (this.getConfig().isRemoteDriver()) {
                chromeOptions.addArguments(new String[]{"window-size=1920,1080", "--no-sandbox"});
            } else {
                chromeOptions.addArguments(new String[]{"start-maximized", "--no-sandbox"});
            }
        }
        if (this.getConfig().isHeadless()) {
            chromeOptions.addArguments(new String[]{"--headless"});
            chromeOptions.addArguments(new String[]{"--disable-gpu"});
        }
        return chromeOptions;
    }

    private String getSize() {
        return this.getConfig().getSizeOrDevice().getX() + "," + this.getConfig().getSizeOrDevice().getY();
    }

    @Override
    public boolean isHeadlessSupport() {
        return true;
    }
}

