/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common;

import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.ReflectionUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browsers;
import ru.mk.pump.web.common.api.ItemsManager;
import ru.mk.pump.web.common.api.WebObject;
import ru.mk.pump.web.exceptions.ItemManagerException;
import ru.mk.pump.web.utils.WebReporter;

public abstract class AbstractItemsManager<T extends WebObject>
implements ItemsManager<T> {
    private final String[] packages;
    private final Set<Class<? extends T>> itemsSet;
    private final Browsers browsers;
    private final Reporter reporter;
    private T current;
    private List<? extends T> currentList;
    private Set<BiPredicate<AbstractItemsManager<T>, Class<? extends T>>> predicateSet = Sets.newHashSet();

    public AbstractItemsManager(Browsers browsers, Reporter reporter, String ... packagesName) {
        this.browsers = browsers;
        this.reporter = reporter;
        this.packages = packagesName;
        this.itemsSet = this.loadItemsClasses(packagesName);
    }

    public AbstractItemsManager(Browsers browsers, String ... packagesName) {
        this(browsers, WebReporter.getReporter(), packagesName);
    }

    @Override
    @NonNull
    public T getOne(String name) {
        return (T)this.getOneByClass(name, this.getItemClass());
    }

    @Override
    @NonNull
    public List<T> getList(String name) {
        return this.getListByClass(name, this.getItemClass());
    }

    @Override
    @NonNull
    public <V extends T> Set<Class<V>> find(@NonNull String itemName, @NonNull Class<V> itemClass) {
        if (itemName == null) {
            throw new NullPointerException("itemName is marked @NonNull but is null");
        }
        if (itemClass == null) {
            throw new NullPointerException("itemClass is marked @NonNull but is null");
        }
        return this.itemsSet.stream().filter(itemClass::isAssignableFrom).filter(i -> this.findFilter(itemName, (Class<? extends T>)i)).filter(i -> this.predicateSet.stream().allMatch(p -> p.test(this, i))).map(i -> i).collect(Collectors.toSet());
    }

    public AbstractItemsManager<T> addExtraFilter(BiPredicate<AbstractItemsManager<T>, Class<? extends T>> predicate) {
        this.predicateSet.add(predicate);
        return this;
    }

    public AbstractItemsManager<T> clearExtraFilter() {
        this.predicateSet.clear();
        return this;
    }

    @Override
    @NonNull
    public <V extends T> V getOneByClass(String name, Class<V> itemSubClass) {
        if (this.current != null && this.current.getName().equals(name) && this.current.getClass().isAssignableFrom(itemSubClass)) {
            return (V)this.current;
        }
        Set<Class<V>> items = this.find(name, itemSubClass);
        if (items.isEmpty()) {
            throw new ItemManagerException(String.format("Cannot find any item with name '%s' and class '%s'", name, itemSubClass.getCanonicalName())).withManager(this);
        }
        this.current = this.newItem(items.iterator().next());
        return (V)this.current;
    }

    @Override
    @NonNull
    public <V extends T> List<V> getListByClass(String name, Class<V> itemSubClass) {
        Set<Class<V>> items = this.find(name, itemSubClass);
        this.currentList = items.stream().map(this::newItem).collect(Collectors.toList());
        return this.currentList;
    }

    protected T newItem(Class<? extends T> itemClass) {
        try {
            Constructor<T> constructor = this.findConstructor(itemClass);
            constructor.setAccessible(true);
            T result = this.newInstance(constructor, itemClass);
            return this.afterItemCreate(result);
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            throw new ItemManagerException(String.format("Error when try to create item with class '%s'", this.getItemClass().getCanonicalName()), (Throwable)ex).withManager(this);
        }
    }

    protected abstract T newInstance(Constructor<? extends T> var1, Class<? extends T> var2) throws ReflectiveOperationException;

    protected abstract Constructor<? extends T> findConstructor(Class<? extends T> var1) throws ReflectiveOperationException;

    protected abstract T afterItemCreate(T var1);

    protected abstract boolean findFilter(String var1, Class<? extends T> var2);

    protected abstract Class<T> getItemClass();

    private Set<Class<? extends T>> loadItemsClasses(String ... packagesName) {
        if (ArrayUtils.isEmpty((Object[])packagesName)) {
            return Collections.emptySet();
        }
        return ReflectionUtils.getAllClasses(this.getItemClass(), (String[])packagesName);
    }

    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"Items Manager").put("browsers", Strings.toString((Object)this.browsers)).put("current item", Strings.toString(this.current)).put("current list", Strings.toPrettyString(this.currentList)).put("reporter", Strings.toString((Object)this.reporter)).put("loaded items", Strings.toPrettyString(this.itemsSet)).put("packages", Strings.toPrettyString((Object[])this.packages)).build();
    }

    public String toString() {
        return "AbstractItemsManager(packages=" + Arrays.deepToString(this.packages) + ", itemsSet=" + this.getItemsSet() + ", current=" + this.getCurrent() + ", currentList=" + this.getCurrentList() + ", predicateSet=" + this.predicateSet + ")";
    }

    public Set<Class<? extends T>> getItemsSet() {
        return this.itemsSet;
    }

    public Browsers getBrowsers() {
        return this.browsers;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public T getCurrent() {
        return this.current;
    }

    @Override
    public List<? extends T> getCurrentList() {
        return this.currentList;
    }
}

