/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common.pageobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.web.common.api.ParameterTransformer;
import ru.mk.pump.web.common.api.annotations.PComponent;
import ru.mk.pump.web.common.api.annotations.PElement;
import ru.mk.pump.web.common.api.annotations.PPage;
import ru.mk.pump.web.common.pageobject.Annotations;
import ru.mk.pump.web.common.pageobject.ParameterTransformerAnnotation;
import ru.mk.pump.web.elements.api.annotations.Requirements;

public class PumpElementAnnotations
extends Annotations {
    private static final Logger log = LoggerFactory.getLogger(PumpElementAnnotations.class);

    public PumpElementAnnotations(AnnotatedElement annotatedElement) {
        super(annotatedElement);
    }

    @NonNull
    Parameters buildParameters() {
        Parameters parameters = Parameters.of();
        for (Annotation annotation : this.getAnnotatedElement().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ParameterTransformerAnnotation.class)) continue;
            try {
                ParameterTransformer parameterBuilder = annotation.annotationType().getAnnotation(ParameterTransformerAnnotation.class).value().newInstance();
                if (parameterBuilder != null) {
                    parameters.addAll(parameterBuilder.transform(annotation));
                    continue;
                }
                log.error("Cannot find parameter transformer for annotation '{}' and annotated element '{}'", (Object)annotation, (Object)this.getAnnotatedElement());
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(String.format("Error when try to create transformer '%s' for annotation '%s' and annotated element '%s'", annotation.annotationType().getAnnotation(ParameterTransformerAnnotation.class).value().getClass().getSimpleName(), annotation, this.getAnnotatedElement()));
            }
        }
        return parameters;
    }

    @NonNull
    public String getComponentName() {
        if (this.getAnnotatedElement().isAnnotationPresent(PComponent.class)) {
            return this.getAnnotatedElement().getAnnotation(PComponent.class).value();
        }
        return "";
    }

    @NonNull
    public String getComponentDescription() {
        if (this.getAnnotatedElement().isAnnotationPresent(PComponent.class)) {
            return this.getAnnotatedElement().getAnnotation(PComponent.class).desc();
        }
        return "";
    }

    @NonNull
    public String getPageName() {
        if (this.getAnnotatedElement().isAnnotationPresent(PPage.class)) {
            return this.getAnnotatedElement().getAnnotation(PPage.class).value();
        }
        return "";
    }

    @NonNull
    public String getPageDescription() {
        if (this.getAnnotatedElement().isAnnotationPresent(PPage.class)) {
            return this.getAnnotatedElement().getAnnotation(PPage.class).desc();
        }
        return "";
    }

    @NonNull
    public String getPageBaseUrl() {
        if (this.getAnnotatedElement().isAnnotationPresent(PPage.class)) {
            return this.getAnnotatedElement().getAnnotation(PPage.class).baseUrl();
        }
        return "";
    }

    @NonNull
    public String getPageResource() {
        if (this.getAnnotatedElement().isAnnotationPresent(PPage.class)) {
            return this.getAnnotatedElement().getAnnotation(PPage.class).resource();
        }
        return "";
    }

    @NonNull
    public String[] getPageExtraUrls() {
        if (this.getAnnotatedElement().isAnnotationPresent(PPage.class)) {
            return this.getAnnotatedElement().getAnnotation(PPage.class).extraUrls();
        }
        return new String[0];
    }

    @NonNull
    public String getElementName() {
        if (this.getAnnotatedElement().isAnnotationPresent(PElement.class)) {
            return this.getAnnotatedElement().getAnnotation(PElement.class).value();
        }
        return "";
    }

    @NonNull
    public String getElementDescription() {
        if (this.getAnnotatedElement().isAnnotationPresent(PElement.class)) {
            return this.getAnnotatedElement().getAnnotation(PElement.class).desc();
        }
        return "";
    }

    @NonNull
    public Collection<Class<? extends Annotation>> getRequirements() {
        return Arrays.stream(this.getAnnotatedElement().getAnnotations()).map(Object::getClass).filter(a -> a.isAnnotationPresent(Requirements.class)).collect(Collectors.toList());
    }
}

