/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.component;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.web.common.AbstractPageItemList;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.elements.ElementConfig;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.BaseElement;

public class ComponentList<T extends Component & Element>
extends AbstractPageItemList<T> {
    private static final Logger log = LoggerFactory.getLogger(ComponentList.class);
    private Class<? extends Element> initClass;

    public ComponentList(@NonNull Class<T> itemsClass, @NonNull By listBy, @NonNull ElementFactory componentFactory, @NonNull ElementConfig elementConfig) {
        super(itemsClass, listBy, componentFactory, elementConfig);
        if (itemsClass == null) {
            throw new NullPointerException("itemsClass is marked @NonNull but is null");
        }
        if (listBy == null) {
            throw new NullPointerException("listBy is marked @NonNull but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked @NonNull but is null");
        }
        if (elementConfig == null) {
            throw new NullPointerException("elementConfig is marked @NonNull but is null");
        }
    }

    public ComponentList(@NonNull Class<T> itemsClass, @NonNull By listBy, @Nullable BaseElement parent, @NonNull ElementFactory componentFactory, @NonNull ElementConfig elementConfig) {
        super(itemsClass, listBy, parent, componentFactory, elementConfig);
        if (itemsClass == null) {
            throw new NullPointerException("itemsClass is marked @NonNull but is null");
        }
        if (listBy == null) {
            throw new NullPointerException("listBy is marked @NonNull but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked @NonNull but is null");
        }
        if (elementConfig == null) {
            throw new NullPointerException("elementConfig is marked @NonNull but is null");
        }
    }

    public ComponentList<T> withInitFilter(Class<? extends Element> initClass) {
        this.initClass = initClass;
        return this;
    }

    @Override
    public T get(int index) {
        if (this.hasCache(index)) {
            log.debug("Get item in ComponentList of {} from cache index {}", (Object)this.itemsClass, (Object)index);
            return (T)((Component)this.getCache(index));
        }
        Component singleElement = this.parent != null ? (Component)this.itemFactory.newElement(this.itemsClass, this.listBy, this.parent, this.elementConfig) : (Component)this.itemFactory.newElement(this.itemsClass, this.listBy, this.elementConfig);
        ((BaseElement)((Object)singleElement)).setIndex(index);
        log.debug("Create new item in ComponentList {} new element {} with index {}", new Object[]{this.itemsClass, singleElement, index});
        if (this.initClass == null) {
            singleElement.initAllElements();
        } else {
            singleElement.initElementsByClass(this.initClass);
        }
        log.debug("Save new item ComponentList {} save cache index {}", (Object)this.itemsClass, (Object)index);
        return (T)this.saveCache(index, singleElement);
    }

    @Override
    public String toString() {
        return "ComponentList(initClass=" + this.initClass + ")";
    }
}

