/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.web.elements.internal.AbstractAction;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;

public class ActionFactory {
    private final InternalElement element;

    protected ActionFactory(InternalElement element) {
        this.element = element;
    }

    public <R> Action<R> newAction(BiFunction<WebElement, Parameters, R> actionBiFunction, String name) {
        return new AbstractAction<R>(actionBiFunction, this.element, name){};
    }

    public <R> Action<R> newAction(Function<WebElement, R> actionSupplier, String name) {
        return new AbstractAction<R>((webElement, param) -> actionSupplier.apply((WebElement)webElement), this.element, name){};
    }

    public <R> Action<R> newAction(Supplier<R> actionSupplier, String name) {
        return new AbstractAction<R>((webElement, param) -> actionSupplier.get(), this.element, name){};
    }

    public Action newVoidAction(BiConsumer<WebElement, Parameters> actionConsumer, String name) {
        return new AbstractAction<String>((webElement, param) -> {
            actionConsumer.accept((WebElement)webElement, (Parameters)param);
            return "void";
        }, this.element, name){};
    }

    public Action newVoidAction(Consumer<WebElement> actionConsumer, String name) {
        return new AbstractAction<String>((webElement, param) -> {
            actionConsumer.accept((WebElement)webElement);
            return "void";
        }, this.element, name){};
    }

    public Action newVoidAction(Runnable actionRunnable, String name) {
        return new AbstractAction<String>((webElement, param) -> {
            actionRunnable.run();
            return "void";
        }, this.element, name){};
    }
}

