/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.State;

public class SetState
extends State {
    @NonNull
    private final Set<State> stateSet = Sets.newLinkedHashSet();
    private final State stateOr;

    private SetState(@NonNull StateType stateType, @NonNull Set<State> states, @Nullable Set<State> statesOr, @Nullable Consumer<WaitResult<Boolean>> tearDown) {
        super(stateType, Collections.emptySet(), tearDown);
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (states == null) {
            throw new NullPointerException("states is marked @NonNull but is null");
        }
        states.forEach(i -> {
            if (i instanceof SetState) {
                this.stateSet.addAll(((SetState)i).getStateSet());
            } else {
                this.stateSet.add((State)i);
            }
        });
        if (statesOr != null && !statesOr.isEmpty()) {
            this.stateOr = State.of(StateType.OR_STATUS_UNION, Collections.emptySet());
            this.stateOr.withName("");
            this.toStateOr(statesOr);
        } else {
            this.stateOr = null;
        }
    }

    public static SetState of(@NonNull StateType stateType, State ... states) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (states == null) {
            throw new NullPointerException("states is marked @NonNull but is null");
        }
        if (states.length == 0) {
            throw new IllegalArgumentException("States varargs cannot be nonArg or null");
        }
        LinkedHashSet and = Sets.newLinkedHashSet();
        LinkedHashSet or = Sets.newLinkedHashSet();
        Arrays.stream(states).forEach(item -> {
            if (item.type().isOr()) {
                or.add(item);
            } else {
                and.add(item);
            }
        });
        return new SetState(stateType, and, or, null);
    }

    @Override
    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"SetState").put("state type", this.type().name()).put("state name", this.name()).put("result", Strings.toString(this.result())).put("states", Strings.toPrettyString(this.getAll())).build();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SetState(");
        sb.append("stateType=").append(this.type().name());
        sb.append(", result=").append(Strings.toString(this.result()));
        sb.append(", name='").append(this.name());
        if (this.getTearDown().isPresent()) {
            sb.append(", tearDown=").append("exists");
        } else {
            sb.append(", tearDown=").append("empty");
        }
        sb.append(", states=").append(Strings.toPrettyString(this.getAll()));
        sb.append(')');
        return sb.toString();
    }

    private void toStateOr(Set<State> statesOrSet) {
        if (this.stateOr == null) {
            return;
        }
        for (State item : statesOrSet) {
            if (item instanceof SetState && ((SetState)item).getStateOr() != null) {
                this.stateOr.withPayload((Set)Preconditions.checkNotNull(((SetState)item).getStateOr().get()));
            } else {
                this.stateOr.withPayload(item.get());
            }
            this.stateOr.withName(this.stateOr.name() + " OR " + item.name()).withTearDown(item.getTearDown().orElse(null));
        }
        if (statesOrSet.size() > 1) {
            this.stateOr.withName(this.stateOr.name().replaceFirst(" OR ", ""));
        }
    }

    private Set<State> getAll() {
        ImmutableSet.Builder builder = ImmutableSet.builder().addAll(this.stateSet);
        if (this.stateOr != null) {
            builder.add((Object)this.stateOr);
        }
        return builder.build();
    }

    @NonNull
    public Set<State> getStateSet() {
        return this.stateSet;
    }

    public State getStateOr() {
        return this.stateOr;
    }
}

