/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.elements.internal.FindStrategy;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementFinderNotFoundException;

class SingleElementStrategy
extends FindStrategy {
    private static final Logger log = LoggerFactory.getLogger(SingleElementStrategy.class);

    public SingleElementStrategy(InternalElement target) {
        super(target);
    }

    @Override
    public WebElement findSelf() {
        if (this.isRoot()) {
            return this.getFromRoot();
        }
        WebElement parent = this.getTarget().getParent().orElseThrow(() -> new ElementFinderNotFoundException("Cannot find parent element").withTargetElement(this.getTarget())).getFinder().get();
        return this.getFromParent(parent);
    }

    protected WebElement getFromRoot() {
        try {
            if (ConfigurationHolder.get().getElement().isFrameSupport()) {
                this.getTarget().getBrowser().actions().switchToRootFrame();
            }
            WebElement res = this.getTarget().getBrowser().getDriver().findElement(this.getTarget().getBy());
            this.getTarget().getFinder().setCache(res);
            return res;
        }
        catch (WebDriverException ex) {
            this.getTarget().getFinder().setCache(null);
            this.onException();
            throw new ElementFinderNotFoundException("Find root element error", (Throwable)ex).withTargetElement(this.getTarget());
        }
    }

    protected void onException() {
    }

    protected WebElement getFromParent(WebElement parent) {
        try {
            WebElement res = parent.findElement(this.getTarget().getBy());
            this.getTarget().getFinder().setCache(res);
            return res;
        }
        catch (StaleElementReferenceException ex) {
            this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            this.onException();
            throw ex;
        }
        catch (NotFoundException ex) {
            if (ConfigurationHolder.get().getElement().isFrameSupport()) {
                this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            }
            this.onException();
            throw ex;
        }
        catch (WebDriverException ex) {
            this.getTarget().getParent().ifPresent(p -> p.getFinder().setCache(null));
            this.onException();
            throw ex;
        }
    }
}

