/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.interfaces.PrettyPrinter;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.Finder;

public class State
implements StrictInfo,
PrettyPrinter {
    private final StateType stateType;
    private WaitResult<Boolean> result;
    private String name;
    private Set<Callable<Boolean>> payload = Sets.newLinkedHashSet();
    private Consumer<WaitResult<Boolean>> tearDown;

    protected State(@NonNull StateType stateType, @NonNull Set<Callable<Boolean>> payload, @Nullable Consumer<WaitResult<Boolean>> tearDown) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked @NonNull but is null");
        }
        this.payload.addAll(payload);
        this.stateType = stateType;
        this.name = stateType.toString();
        this.tearDown = tearDown;
    }

    public static State of(@NonNull StateType stateType, @NonNull Set<Callable<Boolean>> payload) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked @NonNull but is null");
        }
        return new State(stateType, payload, null);
    }

    public static State of(@NonNull StateType stateType, @NonNull Function<WaitResult<WebElement>, Boolean> payload, @NonNull Finder finder) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked @NonNull but is null");
        }
        if (finder == null) {
            throw new NullPointerException("finder is marked @NonNull but is null");
        }
        return State.of(stateType, () -> {
            finder.clearCache();
            return (Boolean)payload.apply(finder.findFast());
        });
    }

    public static State of(@NonNull StateType stateType, @NonNull Callable<Boolean> payload) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked @NonNull but is null");
        }
        return new State(stateType, Sets.newHashSet((Object[])new Callable[]{payload}), null);
    }

    public static State of(@NonNull StateType stateType, @NonNull Callable<Boolean> payload, Consumer<WaitResult<Boolean>> tearDown) {
        if (stateType == null) {
            throw new NullPointerException("stateType is marked @NonNull but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked @NonNull but is null");
        }
        return new State(stateType, Sets.newHashSet((Object[])new Callable[]{payload}), tearDown);
    }

    @NonNull
    public Set<Callable<Boolean>> get() {
        return this.payload;
    }

    public StateType type() {
        return this.stateType;
    }

    public String name() {
        return this.name;
    }

    public State withName(String name) {
        this.name = name;
        return this;
    }

    public Optional<Consumer<WaitResult<Boolean>>> getTearDown() {
        return Optional.ofNullable(this.tearDown);
    }

    public State withTearDown(Consumer<WaitResult<Boolean>> tearDown) {
        this.tearDown = tearDown;
        return this;
    }

    public String toPrettyString() {
        return Strings.toPrettyString(this.getInfo());
    }

    protected State withPayload(Set<Callable<Boolean>> payload) {
        this.payload.addAll(payload);
        return this;
    }

    public State setResult(@Nullable WaitResult<Boolean> result) {
        this.result = result;
        return this;
    }

    public WaitResult<Boolean> result() {
        return this.result;
    }

    public boolean isResolved() {
        return this.result != null;
    }

    public Map<String, String> getInfo() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("type", this.getClass().getSimpleName());
        result.put("stateType", this.stateType.toString());
        result.put("result", Strings.toString(this.result));
        if (!this.stateType.toString().equals(this.name)) {
            result.put("name", this.name);
        }
        return result;
    }

    public int hashCode() {
        int result1 = this.stateType != null ? this.stateType.hashCode() : 0;
        result1 = 31 * result1 + (this.result != null && this.result.getResult() != null ? ((Boolean)this.result.getResult()).hashCode() : 0);
        result1 = 31 * result1 + (this.name != null ? this.name.hashCode() : 0);
        result1 = 31 * result1 + (this.payload != null ? this.payload.getClass().hashCode() : 0);
        result1 = 31 * result1 + (this.tearDown != null ? 1 : 0);
        return result1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State that = (State)o;
        if (this.stateType != that.stateType) {
            return false;
        }
        if (!Objects.equals(this.result != null ? (Boolean)this.result.getResult() : null, that.result != null ? (Boolean)that.result.getResult() : null)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!Objects.equals(this.payload != null ? this.payload.getClass() : null, that.payload != null ? that.payload.getClass() : null)) {
            return false;
        }
        return Objects.nonNull(this.tearDown) ? Objects.nonNull(that.tearDown) : Objects.isNull(that.tearDown);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(stateType=" + this.stateType.toString() + ", result=" + Strings.toString(this.result) + ", name='" + this.name + '\'' + ')';
    }
}

