/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.PumpException;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.elements.internal.ElementWaiter;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.StateNotifier;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.BrowserException;
import ru.mk.pump.web.exceptions.ElementStateException;

public class StateResolver
extends StateNotifier {
    private static final Logger log = LoggerFactory.getLogger(StateResolver.class);
    private final InternalElement internalElement;

    public StateResolver(InternalElement internalElement) {
        this.internalElement = internalElement;
    }

    public State resolveFast(State state) {
        return this.resolve(state, 500);
    }

    public State resolve(State state, final ElementWaiter waiter) {
        StateResolver resolver = new StateResolver(this.internalElement){

            @Override
            protected ElementWaiter waiter() {
                return waiter;
            }
        };
        if (state instanceof SetState) {
            return resolver.resolve((SetState)state);
        }
        return resolver.resolve(state);
    }

    public State resolve(State state, int timeoutMs, int delayMs) {
        return this.resolve(state, this.waiter().withTimeoutMs(timeoutMs).withDelay(delayMs));
    }

    public State resolve(State state, int timeoutMs) {
        return this.resolve(state, this.waiter().withTimeoutMs(timeoutMs));
    }

    public State resolve(State state) {
        return this.resolveAnd(state);
    }

    public SetState resolve(SetState state) {
        long timeout;
        this.notifyOnBefore((Pair<State, InternalElement>)Pair.of((Object)state, (Object)this.internalElement));
        long syncTimeLeft = timeout = (long)(this.waiter().getTimeout() * 1000);
        WaitResult<Boolean> result = WaitResult.trueResult((long)0L, (int)this.waiter().getTimeout());
        if (state.getStateOr() != null && !state.getStateOr().get().isEmpty()) {
            result = this.resolveOr(state.getStateOr()).result();
            syncTimeLeft -= result.getElapsedTime();
        }
        if (!state.getStateSet().isEmpty() && result.isSuccess()) {
            for (State item : state.getStateSet()) {
                this.resolveAnd(item);
                result = item.result();
                if ((syncTimeLeft -= result.getElapsedTime()) > 0L && result.isSuccess()) continue;
                state.setResult((WaitResult<Boolean>)WaitResult.falseResult((long)(timeout - syncTimeLeft), (int)this.waiter().getTimeout(), (Throwable)result.getCause()).withExceptionOnFail(waitResult -> this.newResolvedException(state, (WaitResult<Boolean>)waitResult)));
                this.notifyOnFinish((Pair<State, InternalElement>)Pair.of((Object)state, (Object)this.internalElement));
                return state;
            }
        } else if (!result.isSuccess()) {
            state.setResult((WaitResult<Boolean>)WaitResult.falseResult((long)result.getElapsedTime(), (int)this.waiter().getTimeout(), (Throwable)result.getCause()).withExceptionOnFail(waitResult -> this.newResolvedException(state, (WaitResult<Boolean>)waitResult)));
            this.notifyOnFinish((Pair<State, InternalElement>)Pair.of((Object)state, (Object)this.internalElement));
            return state;
        }
        state.setResult((WaitResult<Boolean>)WaitResult.trueResult((long)(timeout - syncTimeLeft), (int)this.waiter().getTimeout()));
        this.notifyOnFinish((Pair<State, InternalElement>)Pair.of((Object)state, (Object)this.internalElement));
        return state;
    }

    State resolveOr(State state) {
        WaitResult res = this.waiter().withDelay(ElementWaiter.DEFAULT_DELAY_MS).wait(() -> state.get().stream().anyMatch(this::call)).withExceptionOnFail(waitResult -> this.newResolvedException(state, (WaitResult<Boolean>)waitResult));
        state.getTearDown().ifPresent(waitResultConsumer -> waitResultConsumer.accept(res));
        this.throwIfCause((WaitResult<Boolean>)res);
        return state.setResult((WaitResult<Boolean>)res);
    }

    State resolveAnd(State state) {
        WaitResult res = this.waiter().withDelay(ElementWaiter.DEFAULT_DELAY_MS).wait(() -> state.get().stream().allMatch(this::call)).withExceptionOnFail(waitResult -> this.newResolvedException(state, (WaitResult<Boolean>)waitResult));
        state.getTearDown().ifPresent(waitResultConsumer -> waitResultConsumer.accept(res));
        this.throwIfCause((WaitResult<Boolean>)res);
        return state.setResult((WaitResult<Boolean>)res);
    }

    protected PumpException newResolvedException(State state, WaitResult<Boolean> waitResult) {
        return new ElementStateException(String.format("PElement was not became to expected state '%s' in timeout '%s' sec", state.name(), this.waiter().getTimeout()), waitResult.getCause()).withTargetState(state).withElement(this.internalElement);
    }

    protected ElementWaiter waiter() {
        return this.internalElement.getWaiter();
    }

    private boolean call(Callable<Boolean> s) {
        try {
            return s.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return false;
        }
    }

    private void throwIfCause(WaitResult<Boolean> booleanWaitResult) {
        booleanWaitResult.ifHasCause(cause -> {
            if (cause instanceof BrowserException) {
                booleanWaitResult.throwExceptionOnFail();
            }
        });
    }

    public InternalElement getInternalElement() {
        return this.internalElement;
    }
}

