/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal.impl;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.part.WithSubItems;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.DocParameters;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.page.api.Page;

@DocParameters(value={"SELECTOR_ITEMS_BY", "SELECTOR_STATIC_ITEMS"})
public abstract class AbstractWithItems
extends BaseElement
implements WithSubItems {
    protected static final int CHANGING_TIMEOUT = ConfigurationHolder.get().getElement().getSubItemsChangingTimeout() * 1000;
    private static final int CHANGING_DELAY = ConfigurationHolder.get().getElement().getSubItemsChangingPoolDelay();
    private By itemsByCache;
    private Boolean staticItems = true;
    private By[] itemsBy;
    protected List<Element> itemsCache = null;

    public AbstractWithItems(By avatarBy, Page page) {
        super(avatarBy, page);
    }

    public AbstractWithItems(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
    }

    public AbstractWithItems(By avatarBy, Browser browser) {
        super(avatarBy, browser);
    }

    @Override
    public List<Element> getItems() {
        Action<List> action = this.newDelegateActionFactory().newAction(el -> {
            if (!this.getStaticItems().booleanValue() || this.itemsCache == null || this.itemsCache.isEmpty()) {
                this.getWaiter().withTimeoutMs(CHANGING_TIMEOUT).withTimeoutMs(CHANGING_DELAY).waitPredicate(this::refreshItemsCache, Objects::equals);
            }
            return this.itemsCache;
        }, "Get sub-elements list").withStrategy(ActionStrategy.SIMPLE);
        return this.getActionExecutor().execute(action);
    }

    @Override
    public WaitResult<Boolean> hasItems(int count, int timeoutMs) {
        SetState state = (SetState)SetState.of(StateType.OTHER, this.exists(), State.of(StateType.EXISTS, () -> this.refreshItemsCache() >= count)).withName(String.format("Items count not less '%d'", count));
        return this.getInternalStateResolver().resolve((State)state, timeoutMs).result();
    }

    @Override
    public WaitResult<Boolean> hasItems(int count) {
        SetState state = (SetState)SetState.of(StateType.OTHER, this.exists(), State.of(StateType.EXISTS, () -> this.refreshItemsCache() >= count)).withName(String.format("Items count not less '%d'", count));
        return this.getInternalStateResolver().resolve(state).result();
    }

    @Override
    public boolean isNotEnoughChanging(int timeoutMs) {
        return this.getWaiter().withTimeoutMs(timeoutMs).withDelay(CHANGING_DELAY).waitPredicate(this::getItemsTextFast, StringUtils::equalsIgnoreCase).isSuccess();
    }

    @Override
    public boolean isNotEnoughChanging(int timeoutMs, int delayMs) {
        return this.getWaiter().withTimeoutMs(timeoutMs).withDelay(delayMs).waitPredicate(this::getItemsTextFast, StringUtils::equalsIgnoreCase).isSuccess();
    }

    public int refreshItemsCache() {
        if (this.itemsByCache == null) {
            this.itemsCache = this.getSubElements(Element.class).findList(this.getItemsBy());
            if (!this.itemsCache.isEmpty()) {
                this.itemsByCache = this.itemsCache.get(0).advanced().getBy();
            }
        } else {
            this.itemsCache = this.getSubElements(Element.class).findList(this.itemsByCache);
        }
        return this.itemsCache.size();
    }

    public abstract String getItemsTextFast();

    @Override
    protected void initFromParams() {
        super.initFromParams();
        this.setStaticItems((Boolean)ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.SELECTOR_STATIC_ITEMS.getName(), Boolean.class, (Object)this.getStaticItems()));
        this.setItemsBy((By[])ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.SELECTOR_ITEMS_BY.getName(), By[].class, (Object)this.getItemsBy()));
    }

    protected Boolean getStaticItems() {
        return this.staticItems;
    }

    protected void setStaticItems(Boolean staticItems) {
        this.staticItems = staticItems;
    }

    protected By[] getItemsBy() {
        return this.itemsBy;
    }

    protected void setItemsBy(By[] itemsBy) {
        this.itemsBy = itemsBy;
    }

    protected List<Element> getItemsCache() {
        return this.itemsCache;
    }

    protected void setItemsCache(List<Element> itemsCache) {
        this.itemsCache = itemsCache;
    }
}

