/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal.impl;

import java.util.Map;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.annotations.FrameworkImpl;
import ru.mk.pump.web.elements.api.concrete.DropDown;
import ru.mk.pump.web.elements.api.concrete.complex.Child;
import ru.mk.pump.web.elements.api.part.Clickable;
import ru.mk.pump.web.elements.api.part.SelectedItems;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.DocParameters;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.impl.AbstractSelectorItems;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.page.api.Page;

@FrameworkImpl
@DocParameters(value={"DROPDOWN_EXPAND_BY", "DROPDOWN_BEFORE_SELECT"})
class DropDownImpl
extends AbstractSelectorItems
implements DropDown {
    private static final Logger log = LoggerFactory.getLogger(DropDownImpl.class);
    public static final By[] DEFAULT_LOAD_ICON = new By[0];
    private Child<Element> loadIcon;
    private static final By[] DEFAULT_EXPAND_BY = new By[]{By.xpath((String)"//i[contains(@class,chevron)]"), By.xpath((String)".")};
    private By[] expandBy = DEFAULT_EXPAND_BY;
    private Clickable expandButton = null;
    private Boolean beforeSelect = true;

    public DropDownImpl(By avatarBy, Page page) {
        super(avatarBy, page);
    }

    public DropDownImpl(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
    }

    public DropDownImpl(By avatarBy, Browser browser) {
        super(avatarBy, browser);
    }

    @Override
    protected void initFromParams() {
        super.initFromParams();
        this.expandBy = (By[])ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.DROPDOWN_EXPAND_BY.getName(), By[].class, (Object)this.expandBy);
        this.beforeSelect = (Boolean)ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.DROPDOWN_BEFORE_SELECT.getName(), Boolean.class, (Object)this.beforeSelect);
    }

    protected Child<Element> getLoadIcon() {
        if (this.loadIcon == null) {
            this.loadIcon = new Child((BaseElement)this, ElementParams.DROPDOWN_LOAD_BY.getName()).withDefaultBy(DEFAULT_LOAD_ICON);
        }
        return this.loadIcon;
    }

    @Override
    public void select(String itemText) {
        if (this.beforeSelect.booleanValue()) {
            this.beforeSelect();
        }
        super.select(itemText);
    }

    @Override
    public void select(int index) {
        if (this.beforeSelect.booleanValue()) {
            this.beforeSelect();
        }
        super.select(index);
    }

    @Override
    public boolean isExpand() {
        return !this.getItems().isEmpty() && this.getItems().get(0).isDisplayed(1000).result().isSuccess();
    }

    @Override
    public boolean isNotExpand() {
        return this.getItems().isEmpty() || this.getItems().get(0).isNotDisplayed(1000).result().isSuccess();
    }

    @Override
    public SelectedItems expand() {
        if (this.isNotExpand()) {
            this.getExpandButton().click();
        }
        return this;
    }

    protected Clickable getExpandButton() {
        if (this.expandButton == null) {
            this.expandButton = this.getSubElements(Element.class).find(this.expandBy);
        }
        return this.expandButton;
    }

    protected void beforeSelect() {
        if (this.isNotExpand()) {
            this.expand();
        }
    }

    @Override
    public Map<String, String> getInfo() {
        Map<String, String> res = super.getInfo();
        res.put("load icon", Strings.toString(this.loadIcon));
        return res;
    }

    @Override
    public SetState ready() {
        return SetState.of(StateType.READY, State.of(StateType.OTHER, this::isDisappearLoadIcon).withName("Load icon Disappear"), super.ready());
    }

    boolean isDisappearLoadIcon() {
        if (this.getLoadIcon().isDefined()) {
            Element element = this.getLoadIcon().get(Element.class);
            boolean res = element.isNotDisplayed().result().isSuccess();
            return res;
        }
        return true;
    }

    void checkLoadIconFlow() {
        if (this.getLoadIcon().isDefined()) {
            Element element = this.getLoadIcon().get(Element.class);
            element.advanced().getStateResolver().resolve(element.advanced().displayed(), 100, 100).result();
            element.advanced().getStateResolver().resolve(element.advanced().notDisplayed(), 5000, 100).result().throwExceptionOnFail();
        }
    }
}

