/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Complex;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.annotations.FrameworkImpl;
import ru.mk.pump.web.elements.api.concrete.DropDown;
import ru.mk.pump.web.elements.api.concrete.Input;
import ru.mk.pump.web.elements.api.concrete.complex.Child;
import ru.mk.pump.web.elements.api.concrete.complex.InputDropDown;
import ru.mk.pump.web.elements.api.part.SelectedItems;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.DocParameters;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.impl.DropDownImpl;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementException;
import ru.mk.pump.web.page.api.Page;

@FrameworkImpl
@DocParameters(value={"EXTRA_INPUT_BY", "INPUTDROPDOWN_DROPDOWN_BY", "DROPDOWN_LOAD_BY", "DROPDOWN_EXPAND_BY", "DROPDOWN_BEFORE_SELECT", "SELECTOR_STATIC_ITEMS", "SELECTOR_ITEMS_BY", "SELECTED_MARK", "SELECTED_STRATEGY"})
class InputDropDownImpl
extends BaseElement
implements InputDropDown,
Complex {
    private static final Logger log = LoggerFactory.getLogger(InputDropDownImpl.class);
    public static final By[] DEFAULT_INPUT_BY = new By[]{By.tagName((String)"input")};
    public static final By[] DEFAULT_DROP_DOWN_BY = new By[]{By.xpath((String)".")};
    private final Child<Input> input = new Child((BaseElement)this, ElementParams.EXTRA_INPUT_BY.getName()).withDefaultBy(DEFAULT_INPUT_BY);
    private final Child<DropDown> dropDown = new Child((BaseElement)this, ElementParams.INPUTDROPDOWN_DROPDOWN_BY.getName()).withDefaultBy(DEFAULT_DROP_DOWN_BY);

    public InputDropDownImpl(By avatarBy, Page page) {
        super(avatarBy, page);
    }

    public InputDropDownImpl(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
    }

    public InputDropDownImpl(By avatarBy, Browser browser) {
        super(avatarBy, browser);
    }

    @Override
    public String toString() {
        return "InputDropDownImpl(input=" + Strings.toString(this.input) + ", dropDown=" + Strings.toString(this.dropDown) + ") " + super.toString();
    }

    @Override
    public String type(String ... text) {
        String oldItems = ((DropDownImpl)this.getDropDown()).getItemsTextFast();
        String res = this.getInput().type(text);
        ((DropDownImpl)this.getDropDown()).checkLoadIconFlow();
        if (!this.isChanged(oldItems)) {
            this.getReporter().warn(String.format("InputDropDown items did not changed after type text '%s'", Strings.toString((Object)text)), "OLD ITEMS : " + oldItems + System.lineSeparator() + "CURRENT ITEMS : " + ((DropDownImpl)this.getDropDown()).getItemsTextFast() + System.lineSeparator() + Strings.toPrettyString(this.getInfo()));
        }
        return res;
    }

    @Override
    public void set(Parameters params) {
        if (params.has(ElementParams.INPUT_DROPDOWN_SET_STRING)) {
            this.typeAndSelect(params.getOrEmpty(ElementParams.EDITABLE_SET_STRING.getName()).getStringValue(), (String)ParameterUtils.getOrNull((Parameters)params, (String)ElementParams.INPUT_DROPDOWN_SET_STRING.getName(), String.class));
            return;
        }
        if (params.has(ElementParams.INPUT_DROPDOWN_SET_NUMBER)) {
            this.type(params.getOrEmpty(ElementParams.EDITABLE_SET_STRING.getName()).getStringValue());
            this.select((Integer)ParameterUtils.getOrNull((Parameters)params, (String)ElementParams.INPUT_DROPDOWN_SET_NUMBER.getName(), Integer.class));
            return;
        }
        this.typeAndSelect(params.getOrEmpty(ElementParams.EDITABLE_SET_STRING.getName()).getStringValue());
    }

    @Override
    public String getText() {
        return this.getInput().getText();
    }

    @Override
    public void clear() {
        this.getInput().clear();
    }

    @Override
    public String getTextHidden() {
        return this.getInput().getTextHidden();
    }

    @Override
    public Map<String, String> getInfo() {
        Map<String, String> res = super.getInfo();
        res.put("drop down", Strings.toString(this.dropDown));
        res.put("input", Strings.toString(this.input));
        return res;
    }

    @Override
    public boolean isExpand() {
        return this.getDropDown().isExpand();
    }

    @Override
    public boolean isNotExpand() {
        return this.getDropDown().isNotExpand();
    }

    @Override
    public SelectedItems expand() {
        return this.getDropDown().expand();
    }

    @Override
    public void select(String itemText) {
        this.getDropDown().select(itemText);
        this.checkItemsDisappear();
    }

    @Override
    public void select(int index) {
        this.getDropDown().select(index);
        this.checkItemsDisappear();
    }

    @Override
    public Element getSelected() {
        return this.getDropDown().getSelected();
    }

    @Override
    public List<Element> getItems() {
        return this.getDropDown().getItems();
    }

    @Override
    public WaitResult<Boolean> hasItems(int count, int timeoutMs) {
        return this.getDropDown().hasItems(count, timeoutMs);
    }

    @Override
    public WaitResult<Boolean> hasItems(int count) {
        return this.getDropDown().hasItems(count);
    }

    @Override
    public boolean isNotEnoughChanging(int timeoutMs) {
        return this.getDropDown().isNotEnoughChanging(timeoutMs);
    }

    @Override
    public boolean isNotEnoughChanging(int timeoutMs, int delayMs) {
        return this.getDropDown().isNotEnoughChanging(timeoutMs, delayMs);
    }

    public boolean isItemsDisappear() {
        DropDownImpl dropDown = (DropDownImpl)this.getDropDown();
        if (dropDown.getItemsCache().isEmpty()) {
            return true;
        }
        Element element = dropDown.getItemsCache().get(0);
        return element.isNotDisplayed().result().isSuccess();
    }

    @Override
    public void typeAndSelect(String inputText, String dropDownItem) {
        this.type(inputText);
        this.select(dropDownItem);
    }

    @Override
    public void typeAndSelect(String inputAndDropDownText) {
        this.typeAndSelect(inputAndDropDownText, inputAndDropDownText);
    }

    protected Input getInput() {
        Input res = this.input.get(Input.class);
        return res;
    }

    protected DropDown getDropDown() {
        DropDown res = this.dropDown.get(DropDown.class);
        ((DropDownImpl)res).setStaticItems(false);
        Parameters params = Parameters.of((Parameter[])new Parameter[]{ElementParams.DROPDOWN_BEFORE_SELECT.withValue((Object)false), this.getParams().get(ElementParams.DROPDOWN_EXPAND_BY), this.getParams().get(ElementParams.DROPDOWN_LOAD_BY)});
        ((BaseElement)((Object)res)).withParams(params);
        return res;
    }

    protected boolean isChanged(String oldItems) {
        return this.getInternalStateResolver().resolve(this.itemsIsChangedOrEmpty(oldItems), 1000).result().isSuccess();
    }

    protected State itemsIsChangedOrEmpty(String oldItems) {
        return State.of(StateType.OTHER, () -> !StringUtils.equalsIgnoreCase((CharSequence)((DropDownImpl)this.getDropDown()).getItemsTextFast(), (CharSequence)oldItems));
    }

    private void checkItemsDisappear() {
        if (!this.isItemsDisappear()) {
            throw new ElementException("Items did not disappeared after selection").withTargetElement(this);
        }
    }
}

