/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.exceptions;

import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.exceptions.AbstractWebException;

public class ActionExecutingException
extends AbstractWebException {
    static final String ACTION = "action";
    static final String TITLE = "Executing action '%s' error";

    public ActionExecutingException(Action action) {
        this(action, null);
    }

    public ActionExecutingException(Action action, Throwable throwable) {
        super(ActionExecutingException.message(action), throwable);
        this.withBrowser(action.getTarget().getBrowser());
        this.withPage(action.getTarget().getPage());
        this.addTarget(ACTION, action);
    }

    public ActionExecutingException(String description, Action action) {
        this(action);
        this.getSourceMessage().withDesc(description);
    }

    public ActionExecutingException(String description, Action action, Throwable throwable) {
        this(action, throwable);
        this.getSourceMessage().withDesc(description);
    }

    private static PumpMessage message(Action action) {
        return new PumpMessage(String.format(TITLE, action.name()));
    }
}

