/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.items;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import ru.mk.pump.web.interpretator.items.AbstractItem;

public final class Method
extends AbstractItem<String> {
    private List<Object> args = Lists.newArrayList();

    public Method(String source) {
        super(source);
    }

    public boolean hasArgs() {
        return !this.args.isEmpty();
    }

    public Object[] getArgs() {
        return this.args.toArray();
    }

    public Method addArg(Object arg) {
        this.args.add(arg);
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("args", this.args).add("source", this.getSource()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Method)) {
            return false;
        }
        Method other = (Method)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Method;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }
}

