/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import java.util.Arrays;
import javax.annotation.Nullable;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.interpretator.rules.Rule;

abstract class AbstractRule<T>
implements Rule<T> {
    AbstractRule() {
    }

    @Override
    public final boolean parseEnd(String left, String right) {
        return Strings.isEmpty((String)right) || this.parseEndOr(left, right) && Arrays.stream(this.getEscapes()).noneMatch(esc -> left.endsWith("/") && right.startsWith((String)esc));
    }

    protected abstract boolean parseEndOr(String var1, String var2);

    protected abstract T value(String var1);

    @Override
    public int minSize() {
        return 1;
    }

    @Override
    @Nullable
    public final T toValue(String string) {
        return this.value(Arrays.stream(this.getEscapes()).reduce(string, (str, esc) -> str.replaceAll("/" + esc, (String)esc)));
    }

    @Override
    public String[] getEscapes() {
        return new String[0];
    }
}

