/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.mk.pump.commons.utils.Groovy;
import ru.mk.pump.web.interpretator.rules.ArgumentRule;
import ru.mk.pump.web.interpretator.rules.SeparateValue;

final class GroovyArgumentRule
extends ArgumentRule<Object>
implements SeparateValue {
    private static final String GROOVY_PATTERN = "^\\$?groovy\\{(.*)}$";
    private final Groovy groovy;

    public GroovyArgumentRule(Groovy groovy) {
        this.groovy = groovy;
    }

    @Override
    public boolean parseStart(String left, String right) {
        return right.matches("^\\$groovy\\{(.*)}.*");
    }

    @Override
    public boolean parseEndOr(String left, String right) {
        return left.endsWith("}");
    }

    @Override
    public Object value(String string) {
        Matcher matcher = Pattern.compile(GROOVY_PATTERN).matcher(string);
        if (matcher.find()) {
            return this.groovy.evalGroovy(matcher.group(1));
        }
        return null;
    }

    public String toString() {
        return "GroovyArgumentRule()";
    }
}

