/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.PumpException;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.utils.Groovy;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.interpretator.items.Field;
import ru.mk.pump.web.interpretator.items.Item;
import ru.mk.pump.web.interpretator.items.Method;
import ru.mk.pump.web.interpretator.items.TestParameter;
import ru.mk.pump.web.interpretator.rules.Accumulator;
import ru.mk.pump.web.interpretator.rules.ArgumentRule;
import ru.mk.pump.web.interpretator.rules.EmptyArgumentRule;
import ru.mk.pump.web.interpretator.rules.GroovyArgumentRule;
import ru.mk.pump.web.interpretator.rules.IndexRule;
import ru.mk.pump.web.interpretator.rules.PumpkinParser;
import ru.mk.pump.web.interpretator.rules.Rule;
import ru.mk.pump.web.interpretator.rules.SeparateValue;
import ru.mk.pump.web.interpretator.rules.StringArgumentRule;
import ru.mk.pump.web.interpretator.rules.StringRule;
import ru.mk.pump.web.interpretator.rules.TestVarArgument;
import ru.mk.pump.web.interpretator.rules.TitleRule;

public final class Pumpkin {
    private static final Logger log = LoggerFactory.getLogger(Pumpkin.class);
    private Groovy groovy;
    private final Set<Rule> rules;
    private Deque<Item> itemsCache;
    private Item currentItem;
    private String currentExpression;
    private PumpkinParser parser;
    private Map<String, Object> testVars;

    public Pumpkin(Map<String, Object> testVars) {
        this(testVars, Groovy.of());
    }

    public Pumpkin(Map<String, Object> testVars, Groovy groovy) {
        this(testVars, groovy, (Set<Rule>)ImmutableSet.of((Object)new EmptyArgumentRule(), (Object)new TestVarArgument(testVars), (Object)new GroovyArgumentRule(groovy), (Object)new StringArgumentRule(), (Object)new IndexRule(), (Object)new TitleRule(), (Object[])new Rule[0]));
    }

    public Pumpkin(Map<String, Object> testVars, Groovy groovy, Set<Rule> rules) {
        this.groovy = groovy;
        this.rules = rules;
        this.testVars = testVars;
    }

    public static Pumpkin newParamParser(Map<String, Object> testVars) {
        Groovy groovy = Groovy.of();
        return new Pumpkin(testVars, groovy, (Set<Rule>)ImmutableSet.of((Object)new TestVarArgument(testVars), (Object)new GroovyArgumentRule(groovy), (Object)new StringRule()));
    }

    public Queue<Item> generateItems(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked @NonNull but is null");
        }
        this.currentExpression = expression;
        this.currentItem = null;
        this.itemsCache = Queues.newArrayDeque();
        this.parser = new PumpkinParser(expression, this.rules);
        while (!this.parser.isCompleted()) {
            Optional<Accumulator> accumulator = this.parser.parseNext();
            accumulator.ifPresent(this::handle);
        }
        if (this.itemsCache.isEmpty()) {
            this.itemsCache.add(new TestParameter<String>(expression));
        }
        return this.itemsCache;
    }

    private void handle(Accumulator accumulator) {
        if (this.needNewItem(accumulator)) {
            this.currentItem = this.newItem(accumulator);
            this.itemsCache.add(this.currentItem);
        } else if (this.needModifyItem(accumulator)) {
            this.currentItem = this.modifyCurrentItem(accumulator);
        } else if (this.needParameterItem(accumulator)) {
            this.currentItem = this.newParameter(accumulator);
            this.itemsCache.add(this.currentItem);
        } else {
            throw this.exception("Unexpected rule", accumulator);
        }
    }

    private boolean needNewItem(Accumulator accumulator) {
        return accumulator.getRule() instanceof TitleRule;
    }

    private boolean needParameterItem(Accumulator accumulator) {
        return accumulator.getRule() instanceof SeparateValue;
    }

    private boolean needModifyItem(Accumulator accumulator) {
        return !(!(this.currentItem instanceof Method) && !(this.currentItem instanceof Field) || !(accumulator.getRule() instanceof IndexRule) && !(accumulator.getRule() instanceof ArgumentRule));
    }

    private Item newParameter(Accumulator accumulator) {
        if (accumulator.getRule() instanceof SeparateValue) {
            return new TestParameter(accumulator.getRule().toValue(accumulator.getResult()));
        }
        throw this.exception("Unexpected rule", accumulator);
    }

    private Item newItem(Accumulator accumulator) {
        if (accumulator.getRule() instanceof TitleRule) {
            return new Field(accumulator.getResult());
        }
        throw this.exception("Unexpected rule", accumulator);
    }

    private Item modifyCurrentItem(Accumulator accumulator) {
        if (accumulator.getRule() instanceof ArgumentRule) {
            if (this.currentItem instanceof Field) {
                this.mutateCurrent(this.toMethod(this.currentItem));
            } else if (!((Method)this.currentItem).hasArgs()) {
                throw this.exception("New argument in non arguments method", accumulator);
            }
            if (!(accumulator.getRule() instanceof EmptyArgumentRule)) {
                ((Method)this.currentItem).addArg(accumulator.getRule().toValue(accumulator.getResult()));
            }
            return this.currentItem;
        }
        if (accumulator.getRule() instanceof IndexRule) {
            if (this.currentItem instanceof Method) {
                this.mutateCurrent(this.toField(this.currentItem).setIndex((Integer)((IndexRule)accumulator.getRule()).toValue(accumulator.getResult())));
            } else if (((Field)this.currentItem).hasIndex()) {
                throw this.exception("Double index in a field", accumulator);
            }
            int res = (Integer)((IndexRule)accumulator.getRule()).toValue(accumulator.getResult());
            if (res < 0) {
                throw this.exception("Incorrect index", accumulator);
            }
            ((Field)this.currentItem).setIndex(res);
            return this.currentItem;
        }
        throw this.exception("Unexpected rule", accumulator);
    }

    private void mutateCurrent(Item item) {
        this.itemsCache.pollLast();
        this.itemsCache.add(item);
        this.currentItem = item;
    }

    private Method toMethod(Item item) {
        return new Method((String)item.getSource());
    }

    private Field toField(Item item) {
        return new Field((String)item.getSource());
    }

    private PumpException exception(String error, Accumulator accumulator) {
        throw new PumpException(new PumpMessage(error).withPre("Error pampkin parsing").withDesc(String.format("We have tried to parse you expression '%s'. But your expression is incorrect. See pumpkin documentation", this.currentExpression)).addExtraInfo("source", this.currentExpression).addExtraInfo("current item", Strings.toString((Object)this.currentItem)).addExtraInfo("handled items", Strings.toString(this.itemsCache)).addExtraInfo("parser", Strings.toString((Object)accumulator)));
    }

    public String toString() {
        return "Pumpkin(groovy=" + this.groovy + ", rules=" + this.rules + ", itemsCache=" + this.getItemsCache() + ", currentItem=" + this.getCurrentItem() + ", currentExpression=" + this.getCurrentExpression() + ", parser=" + this.getParser() + ", testVars=" + this.testVars + ")";
    }

    protected Deque<Item> getItemsCache() {
        return this.itemsCache;
    }

    protected Item getCurrentItem() {
        return this.currentItem;
    }

    protected String getCurrentExpression() {
        return this.currentExpression;
    }

    protected PumpkinParser getParser() {
        return this.parser;
    }
}

