/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.mk.pump.web.interpretator.rules.ArgumentRule;
import ru.mk.pump.web.interpretator.rules.SeparateValue;

final class TestVarArgument
extends ArgumentRule<Object>
implements SeparateValue {
    private static final String TEST_VAR_PATTERN = "^\\$?\\{(.*)}$";
    private final Map<String, Object> testVars;

    public TestVarArgument(Map<String, Object> testVars) {
        this.testVars = testVars;
    }

    @Override
    public boolean parseStart(String left, String right) {
        return right.matches("^\\$\\{(.*)}.*");
    }

    @Override
    public boolean parseEndOr(String left, String right) {
        return left.endsWith("}");
    }

    @Override
    public Object value(String string) {
        Matcher matcher = Pattern.compile(TEST_VAR_PATTERN).matcher(string);
        if (matcher.find()) {
            return this.testVars.get(matcher.group(1));
        }
        return null;
    }

    public String toString() {
        return "TestVarArgument(testVars=" + this.testVars + ")";
    }
}

