/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import ru.mk.pump.commons.interfaces.PrettyPrinter;
import ru.mk.pump.commons.listener.AbstractNotifier;
import ru.mk.pump.commons.listener.Event;
import ru.mk.pump.commons.listener.Listener;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.Strings;

public final class TestVars
extends AbstractNotifier<Pair<String, Object>, TestVarListener.TestVarEvent, TestVarListener>
implements PrettyPrinter {
    public static final String RESULT = "result";
    public static final String NULL = "null";
    public static final String NULL_STRING = "null_string";
    public static final String EMPTY_STRING = "empty";
    public static final String LAST_PUT = "last";
    private final Map<String, Object> sourceMap;
    private final Map<String, String> sourceStringMap;

    private TestVars(Map<String, Object> sourceMap, Reporter reporter) {
        this.sourceMap = new HashMap<String, Object>(sourceMap);
        this.sourceStringMap = new HashMap<String, String>();
        this.sourceMap.put(NULL, null);
        this.sourceMap.put(NULL_STRING, NULL);
        this.sourceMap.put(EMPTY_STRING, "");
        this.sourceStringMap.putAll(this.toStringMap());
        this.addListener(item -> {
            if (reporter != null && !sourceMap.containsKey(item.getKey())) {
                reporter.info(String.format("Add to global variables with key '%s'", item.getKey()), String.format("key = %s%n%nvalue = %s", item.getKey(), item.getValue()), reporter.attachments().dummy());
            }
        });
    }

    private TestVars(Map<String, Object> sourceMap) {
        this(sourceMap, null);
    }

    private TestVars() {
        this(Maps.newHashMap());
    }

    @NonNull
    public static TestVars of(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return new TestVars().put(key, value);
    }

    @NonNull
    public static TestVars of(@NonNull Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            throw new NullPointerException("sourceMap is marked @NonNull but is null");
        }
        return new TestVars(sourceMap);
    }

    @NonNull
    public static TestVars of(@NonNull Map<String, Object> sourceMap, @NonNull Reporter reporter) {
        if (sourceMap == null) {
            throw new NullPointerException("sourceMap is marked @NonNull but is null");
        }
        if (reporter == null) {
            throw new NullPointerException("reporter is marked @NonNull but is null");
        }
        return new TestVars(sourceMap, reporter);
    }

    @NonNull
    public static TestVars of() {
        return new TestVars();
    }

    @NonNull
    public TestVars put(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.sourceMap.put(key, value);
        this.sourceMap.put(LAST_PUT, value);
        this.sourceStringMap.put(key, Strings.toString((Object)value));
        this.notifyOnPut((Pair<String, Object>)Pair.of((Object)key, (Object)value));
        return this;
    }

    @NonNull
    public TestVars putResult(@Nullable Object value) {
        this.put(RESULT, value);
        return this;
    }

    @Nullable
    public Object getResult() {
        return this.sourceMap.get(RESULT);
    }

    @Nullable
    public Object getLastPut() {
        return this.sourceMap.get(LAST_PUT);
    }

    @Nullable
    public Object get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.get(key);
    }

    @Nullable
    public Object get(@NonNull String key, @Nullable String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.getOrDefault(key, defaultValue);
    }

    public Map<String, String> getStringMap() {
        return Collections.unmodifiableMap(this.sourceStringMap);
    }

    public boolean has(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.containsKey(key);
    }

    @NonNull
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.sourceMap);
    }

    public String toPrettyString() {
        return Strings.toPrettyString(this.sourceMap);
    }

    protected void notifyOnPut(Pair<String, Object> object) {
        this.notify(this.event(object, TestVarListener.TestVarEvent.PUT_VAR));
    }

    private Map<String, String> toStringMap() {
        return this.sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, i -> Strings.toString(i.getValue())));
    }

    public String toString() {
        return "TestVars(sourceMap=" + this.sourceMap + ", sourceStringMap=" + this.sourceStringMap + ")";
    }

    public static interface TestVarListener
    extends Listener<Pair<String, Object>, TestVarEvent> {
        default public void on(Event<Pair<String, Object>, TestVarEvent> event, Object ... args) {
            switch ((TestVarEvent)event.name()) {
                case PUT_VAR: {
                    this.onPut((Pair<String, Object>)((Pair)event.get()));
                }
            }
        }

        public void onPut(Pair<String, Object> var1);

        public static enum TestVarEvent {
            PUT_VAR;

        }
    }
}

