/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.TextStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Pre;
import ru.mk.pump.commons.utils.Strings;

public final class UrlUtils {
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);
    private static final String PROTOCOL_DELIMITER = "://";
    public static String PROTOCOL = "https";

    public static String concatWithPath(@NonNull String baseUrl, String ... path) {
        String res;
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked @NonNull but is null");
        }
        Pre.checkStringNotBlank((String)baseUrl);
        if (UrlUtils.hasPathParam(baseUrl)) {
            res = UrlUtils.fixUrl(UrlUtils.replaceParams(baseUrl, path));
        } else {
            TextStringBuilder sb = new TextStringBuilder(baseUrl);
            if (path != null) {
                Arrays.stream(path).forEach(p -> sb.append("/").append(p));
            }
            res = UrlUtils.fixUrl(sb.toString());
        }
        if (UrlUtils.isUrl(res)) {
            return res;
        }
        if (ArrayUtils.isNotEmpty((Object[])path)) {
            throw new IllegalArgumentException(String.format("Incorrect URL '%s' with params '%s'", baseUrl, Strings.toString((Object)path)));
        }
        throw new IllegalArgumentException(String.format("Incorrect URL '%s'", baseUrl));
    }

    @Nullable
    public static String fixUrl(@Nullable String candidateUrl) {
        URI url;
        if (candidateUrl == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        candidateUrl = UrlUtils.replaceParams(candidateUrl, new String[0]);
        Matcher matcher = Pattern.compile("^([\\w]+)([:/]+)(.*)").matcher(candidateUrl);
        candidateUrl = matcher.find() ? matcher.group(1) + PROTOCOL_DELIMITER + matcher.group(3) : PROTOCOL + PROTOCOL_DELIMITER + candidateUrl;
        try {
            url = new URI(candidateUrl);
        }
        catch (URISyntaxException e) {
            return candidateUrl;
        }
        if (url.getScheme() == null) {
            result.append(PROTOCOL);
        } else {
            result.append(url.getScheme());
        }
        result.append(PROTOCOL_DELIMITER);
        matcher = Pattern.compile("^([^\\w]+)([\\w\\\\.]+.*)").matcher(url.getRawSchemeSpecificPart());
        if (url.getHost() == null && matcher.find()) {
            result.append(matcher.group(2));
            return UrlUtils.fixUrl(result.toString());
        }
        result.append(url.getHost());
        if (url.getPort() != -1) {
            result.append(":");
            result.append(url.getPort());
        }
        if (!Strings.isEmpty((String)url.getPath())) {
            result.append(url.getPath().replaceAll("/+", "/"));
        }
        return UrlUtils.isUrl(result.toString()) ? result.toString() : candidateUrl;
    }

    public static boolean isUrl(@Nullable String candidateUrl) {
        if (candidateUrl == null) {
            return false;
        }
        try {
            new URL(candidateUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static boolean hasPathParam(@Nullable String candidateUrl) {
        if (candidateUrl == null) {
            return false;
        }
        Matcher matcher = Pattern.compile("\\{(\\d)}").matcher(candidateUrl);
        return matcher.find();
    }

    private static String replaceParams(String url, String ... params) {
        Matcher matcher = Pattern.compile("\\{(\\d)}").matcher(url);
        StringBuffer res = new StringBuffer(url.length());
        while (matcher.find()) {
            String rText;
            int number = Integer.parseInt(matcher.group(1));
            if (ArrayUtils.isEmpty((Object[])params)) {
                rText = "parameter_" + number;
            } else if (params.length >= number) {
                rText = params[number - 1];
            } else {
                throw new IllegalArgumentException(String.format("Wrong parameters '%s' count '%s' in URL '%s', expected '%d'", Strings.toString((Object)params), params.length, url, number));
            }
            matcher.appendReplacement(res, rText);
        }
        if (res.length() > 0) {
            return res.toString();
        }
        return url;
    }

    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

