/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.utils;

import org.apache.commons.lang3.reflect.FieldUtils;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Strings;

public final class Xpath {
    private static final Logger log = LoggerFactory.getLogger(Xpath.class);

    public static String fixXpath(String xpath) {
        log.debug("[XPATH] source '{}'", (Object)xpath);
        if (xpath == null || xpath.matches("[.]*|[/]*")) {
            return ".";
        }
        xpath = xpath.replaceAll("/{3,}", "//");
        xpath = xpath.replaceAll("\\.{3,}", "\\.\\.");
        xpath = xpath.replaceAll("(/\\.){2,}", "/.");
        xpath = xpath.replaceAll("(/\\.){2,}", "./");
        xpath = xpath.replaceAll("(?<![./])/\\./(?![./])", "/");
        xpath = xpath.replaceAll("(?<!/)/\\.(?!\\.)", "");
        xpath = xpath.replaceAll("(?<=[\\w/])\\./(?!/)", "");
        xpath = xpath.replaceAll("(?<!/)(\\.\\.)(?!/)", "/..");
        xpath = xpath.replaceAll("(?<=[./])\\.(?=\\w)", "./");
        xpath = xpath.replaceAll("(?<!/)/$", "");
        xpath = xpath.replaceAll("//$", "");
        if ((xpath = xpath.replaceAll("(?<=[\\w/])\\./(?!/)", "")) == null || xpath.matches("[.]{3,}|[/]{3,}")) {
            return ".";
        }
        if (xpath.startsWith("//") || xpath.startsWith("/")) {
            xpath = "." + xpath;
        } else if (!xpath.startsWith(".")) {
            xpath = "./" + xpath;
        }
        log.debug("[XPATH] result '{}'", (Object)xpath);
        return xpath;
    }

    public static By fixIfXpath(By by) {
        if (by instanceof By.ByXPath) {
            String stringXpath = Xpath.getXpathStringOrNull((By.ByXPath)by);
            if (Strings.isEmpty((String)stringXpath)) {
                return by;
            }
            return By.xpath((String)Xpath.fixXpath(stringXpath));
        }
        return by;
    }

    public static String concat(String mainXpath, String xpath) {
        return Xpath.fixXpath(mainXpath) + "/" + Xpath.fixXpath(xpath);
    }

    private static String getXpathStringOrNull(By.ByXPath by) {
        try {
            return (String)FieldUtils.readField((Object)by, (String)"xpathExpression", (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Xpath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

