/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.support.http;

import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSimpleHtmlServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LocalSimpleHtmlServer.class);
    private static final int DEFAULT_PORT = 8080;
    private final int port;
    private final String path;
    private Charset charset = StandardCharsets.UTF_8;
    private HttpServer server;
    private boolean published;

    private LocalSimpleHtmlServer(int port, @Nullable String path) {
        this.port = port;
        this.path = Optional.ofNullable(path).orElse("/");
    }

    public static LocalSimpleHtmlServer of(int port, String path) {
        return new LocalSimpleHtmlServer(port, path);
    }

    public static LocalSimpleHtmlServer of(String path) {
        return LocalSimpleHtmlServer.of(8080, path);
    }

    public static LocalSimpleHtmlServer of() {
        return LocalSimpleHtmlServer.of(null);
    }

    public final TestHtmlServer asTestRule() {
        return this.asTestRule("<!DOCTYPE html> <html> <body> <h2>Simple HTML</h2> <p>Simple buttons</p> <div> <button>Button-1</button> <button>Button-2</button> </div> </body> </html>");
    }

    public final TestHtmlServer asTestRule(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        return new TestHtmlServer(html);
    }

    public synchronized void publish(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            log.info("[SIMPLE HTTP SERVER] Created");
        }
        catch (IOException e) {
            throw new RuntimeException("Error during creating JDK http-server " + this.toString(), e);
        }
        if (this.published) {
            this.server.removeContext(this.path);
        }
        this.server.createContext(this.path, httpExchange -> {
            log.debug("[SIMPLE HTTP SERVER] Get an request '{} from {}'", (Object)httpExchange.getRequestMethod(), (Object)httpExchange.getRequestURI());
            byte[] response = html.getBytes(this.charset);
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=" + this.charset.name());
            httpExchange.sendResponseHeaders(200, response.length);
            try (OutputStream out = httpExchange.getResponseBody();){
                out.write(response);
            }
            log.debug("[SIMPLE HTTP SERVER] Response has been prepared '{} from {}'", (Object)httpExchange.getResponseHeaders(), (Object)httpExchange.getResponseCode());
        });
        log.info("[SIMPLE HTTP SERVER] Handler created on http://localhost:{}{}", (Object)this.port, (Object)this.path);
        if (!this.published) {
            this.server.start();
            this.published = true;
            log.info("[SIMPLE HTTP SERVER] Started on http://localhost:{}{}", (Object)this.port, (Object)this.path);
        }
    }

    @Override
    public void close() {
        Optional.ofNullable(this.server).ifPresent(s -> {
            s.stop(1);
            log.info("[SIMPLE HTTP SERVER] Closed {}", (Object)this.toString());
        });
    }

    public String toString() {
        return "LocalSimpleHtmlServer(port=" + this.port + ", path=" + this.path + ", charset=" + this.charset + ", published=" + this.isPublished() + ")";
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    HttpServer getServer() {
        return this.server;
    }

    public boolean isPublished() {
        return this.published;
    }

    public final class TestHtmlServer
    implements TestRule {
        static final String HTML = "<!DOCTYPE html> <html> <body> <h2>Simple HTML</h2> <p>Simple buttons</p> <div> <button>Button-1</button> <button>Button-2</button> </div> </body> </html>";
        private String html;

        public int getPort() {
            return LocalSimpleHtmlServer.this.port;
        }

        public String getPath() {
            return LocalSimpleHtmlServer.this.path;
        }

        public String getUrl() {
            return "http://localhost:" + LocalSimpleHtmlServer.this.port + LocalSimpleHtmlServer.this.path;
        }

        public void withHtml(String html) {
            this.html = html;
        }

        @Deprecated
        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    LocalSimpleHtmlServer.this.publish(TestHtmlServer.this.html);
                    try {
                        base.evaluate();
                    }
                    finally {
                        LocalSimpleHtmlServer.this.close();
                    }
                }
            };
        }

        public TestHtmlServer(String html) {
            this.html = html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public String getHtml() {
            return this.html;
        }
    }
}

