/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.support.selenium.listener;

import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;
import org.openqa.selenium.support.events.WebDriverEventListener;
import ru.iopump.qa.support.selenium.listener.Highlighter;
import ru.iopump.qa.support.selenium.listener.SingleThreadHighlighterImpl;

@NotThreadSafe
public class HighlighterListener
extends AbstractWebDriverEventListener {
    private final Highlighter highlighter;

    private HighlighterListener(@NonNull Highlighter highlighter) {
        if (highlighter == null) {
            throw new NullPointerException("highlighter is marked non-null but is null");
        }
        this.highlighter = highlighter;
    }

    public static WebDriverEventListener newSingleThreadHighlighterListener() {
        return new HighlighterListener(new SingleThreadHighlighterImpl());
    }

    public HighlighterListener of(Highlighter highlighter) {
        return new HighlighterListener(highlighter);
    }

    public void afterFindBy(By by, WebElement element, WebDriver driver) {
        this.highlighter.unhighlightPrev(element, driver);
        this.highlighter.highlight(element, driver);
    }

    public void beforeNavigateTo(String url, WebDriver driver) {
        this.highlighter.dropState();
    }

    public void beforeNavigateBack(WebDriver driver) {
        this.highlighter.dropState();
    }

    public void beforeNavigateForward(WebDriver driver) {
        this.highlighter.dropState();
    }

    public void beforeNavigateRefresh(WebDriver driver) {
        this.highlighter.dropState();
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.highlighter.unhighlightPrev(element, driver);
        this.highlighter.highlight(element, driver);
    }

    public void beforeGetText(WebElement element, WebDriver driver) {
        this.highlighter.unhighlightPrev(element, driver);
        this.highlighter.highlight(element, driver);
    }
}

