/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.support.selenium.listener;

import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import ru.iopump.qa.support.selenium.listener.HUtil;
import ru.iopump.qa.support.selenium.listener.Highlighter;

@NotThreadSafe
public class SingleThreadHighlighterImpl
implements Highlighter {
    private final String borderStyle;
    private WebElement prevElement;

    public SingleThreadHighlighterImpl(int px, String color) {
        Objects.requireNonNull(color, "Color cannot be null");
        this.borderStyle = px + "px solid " + color.toLowerCase();
    }

    public SingleThreadHighlighterImpl() {
        this(3, "red");
    }

    @Override
    public boolean highlight(WebElement element, WebDriver driver) {
        String currentStyle;
        if (element != null && driver != null && !(currentStyle = HUtil.exec("arguments[0].style.border", element, driver).toLowerCase()).contains(this.borderStyle)) {
            HUtil.exec(HUtil.jsBorder(this.borderStyle), element, driver);
            this.prevElement = element;
            return true;
        }
        return false;
    }

    @Override
    public boolean unhighlightPrev(WebElement elementWillBeHighlighted, WebDriver driver) {
        String lastBorderStyle;
        if (this.prevElement != null && elementWillBeHighlighted != this.prevElement && driver != null && !(lastBorderStyle = HUtil.exec("arguments[0].style.border", this.prevElement, driver).toLowerCase()).contains(this.borderStyle)) {
            String revertedStyle = lastBorderStyle.replaceAll(this.borderStyle, "");
            HUtil.exec(HUtil.jsBorder(revertedStyle), this.prevElement, driver);
            this.dropState();
            return true;
        }
        return false;
    }

    @Override
    public void dropState() {
        this.prevElement = null;
    }

    @Override
    public void close() {
        this.dropState();
    }
}

