/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import ru.iopump.qa.support.api.WithValue;
import ru.iopump.qa.util.Str;
import ru.iopump.qa.util.StreamUtil;

public final class EnumUtil {
    @NonNull
    public static <T extends Enum<T>, V> T getByValue(@NonNull Class<T> enumClass, @Nullable V expectedValue) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        return (T)StreamUtil.stream(values).filter(i -> ((WithValue)((Object)i)).hasValue(expectedValue)).findFirst().orElseThrow(() -> new IllegalArgumentException(Str.format("There are no enum items among '{}' with value = '{}'{}", Str.toStr(values), Str.toStr(expectedValue), expectedValue instanceof String ? " ignore case" : "")));
    }

    @NonNull
    public static <T extends Enum<T>> T getByName(@NonNull Class<T> enumClass, @Nullable String expectedEnumName) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        return (T)StreamUtil.stream(values).filter(i -> StringUtils.equalsAnyIgnoreCase((CharSequence)i.name(), (CharSequence[])new CharSequence[]{expectedEnumName})).findFirst().orElseThrow(() -> new IllegalArgumentException(Str.format("There are no enum items among '{}' with name = '{}' ignore case", Str.toStr(values), expectedEnumName)));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private EnumUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

