/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import ru.iopump.qa.exception.QaUtilException;

public final class FileUtil {
    public static boolean ENABLE_WATCHDOG;
    private static FilesWatchdog filesWatchdog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public static FilesWatchdog getFilesWatchdog() {
        if (!ENABLE_WATCHDOG) {
            return new FilesWatchdog(){

                @Override
                public void close() {
                }

                @Override
                public Map<Path, Throwable> getError() {
                    return Collections.emptyMap();
                }

                @Override
                public Collection<Path> getAll() {
                    return Collections.emptyList();
                }
            };
        }
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (filesWatchdog == null || FileUtil.filesWatchdog.closed) {
                filesWatchdog = new FilesWatchdog();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return filesWatchdog;
        }
    }

    @NonNull
    public static Path getClassPathMainDir() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL tmp = loader.getResource("");
        Preconditions.checkState((tmp != null ? 1 : 0) != 0, (Object)"Cannot get classpath dir");
        try {
            return Paths.get(tmp.toURI());
        }
        catch (URISyntaxException e) {
            throw new QaUtilException(e);
        }
    }

    @NonNull
    public static boolean createFile(@NonNull Path path, boolean ... ifNotExists) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            if (Files.notExists(path, new LinkOption[0]) || !ArrayUtils.isNotEmpty((boolean[])ifNotExists) || !ifNotExists[0]) {
                Optional.ofNullable(path.getParent()).ifPresent(x$0 -> FileUtil.createDir(x$0, new boolean[0]));
                Files.deleteIfExists(path);
                FileUtil.getFilesWatchdog().add(Files.createFile(path, new FileAttribute[0]));
                return true;
            }
        }
        catch (IOException e) {
            throw new QaUtilException(e);
        }
        return false;
    }

    @NonNull
    public static boolean createDir(@NonNull Path path, boolean ... ifNotExists) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            if (Files.notExists(path, new LinkOption[0]) || !ArrayUtils.isNotEmpty((boolean[])ifNotExists) || !ifNotExists[0]) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    Files.deleteIfExists(path);
                }
                FileUtil.getFilesWatchdog().add(Files.createDirectories(path, new FileAttribute[0]));
                return true;
            }
        }
        catch (IOException e) {
            throw new QaUtilException(e);
        }
        return false;
    }

    public static boolean isAbsolute(@Nullable String candidate) {
        return Paths.get(candidate == null ? "" : candidate, new String[0]).isAbsolute();
    }

    public static boolean isUserDirRelative(@Nullable String candidate) {
        return Files.exists(FileUtil.getUserDir().resolve(candidate == null ? "" : candidate), new LinkOption[0]);
    }

    public static Path getUserDir() {
        return Paths.get("", new String[0]);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Beta
    public static class FilesWatchdog
    implements Closeable {
        private final Collection<Path> watchedPaths = new ConcurrentLinkedQueue<Path>();
        private final Map<Path, Throwable> errors = new HashMap<Path, Throwable>();
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            Class<FileUtil> clazz = FileUtil.class;
            synchronized (FileUtil.class) {
                this.watchedPaths.parallelStream().forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        this.errors.put((Path)path, e);
                    }
                });
                this.closed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Map<Path, Throwable> getError() {
            return ImmutableMap.copyOf(this.errors);
        }

        public Collection<Path> getAll() {
            return Collections.unmodifiableCollection(this.watchedPaths);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Path path) {
            Class<FileUtil> clazz = FileUtil.class;
            synchronized (FileUtil.class) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"FilesWatchdog already closed");
                Optional.ofNullable(path).ifPresent(this.watchedPaths::add);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private FilesWatchdog() {
        }
    }
}

