/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import ru.iopump.qa.util.Str;

public final class VarUtil {
    public static Map<String, String> getAll() {
        return ImmutableMap.builder().putAll(System.getenv()).putAll(System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> Str.toStr(e.getKey()), e -> Str.toStr(e.getValue())))).build();
    }

    public static Optional<String> get(@NonNull String propertyNameAkaKey) {
        if (propertyNameAkaKey == null) {
            throw new NullPointerException("propertyNameAkaKey is marked non-null but is null");
        }
        String sys = System.getProperty(propertyNameAkaKey);
        String env = System.getenv(propertyNameAkaKey);
        return sys != null ? Optional.of(sys) : Optional.ofNullable(env);
    }

    @Nullable
    public static String getOrDefault(@NonNull String propertyNameAkaKey, @Nullable String defaultValue) {
        if (propertyNameAkaKey == null) {
            throw new NullPointerException("propertyNameAkaKey is marked non-null but is null");
        }
        return VarUtil.get(propertyNameAkaKey).orElse(defaultValue);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private VarUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

