/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import ru.iopump.qa.util.Str;

public final class ClassUtil {
    public static <TypeT> Optional<TypeT> cast(@Nullable Object object, @NonNull Class<TypeT> expectedClass, @Nullable String message) {
        if (expectedClass == null) {
            throw new NullPointerException("expectedClass is marked non-null but is null");
        }
        if (object == null) {
            return Optional.empty();
        }
        if (expectedClass.isInstance(object)) {
            return Optional.of(expectedClass.cast(object));
        }
        throw new ClassCastException(Str.format("Cannot cast class '{}' with value '{}' to class '{}'.\nMessage: '{}'", ClassUtil.getClass(object), Str.toString(object), expectedClass, StringUtils.defaultIfBlank((CharSequence)message, (CharSequence)"empty")));
    }

    @NonNull
    public static Class<?> getClass(@Nullable Object value) {
        if (value == null) {
            return Object.class;
        }
        return value.getClass();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ClassUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

