/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.joor.Reflect;
import ru.iopump.qa.util.StreamUtil;

public final class ReflectionUtil {
    @NonNull
    public static Collection<Class<?>> getGenericTypes(@Nullable Field field) {
        if (field == null) {
            return Collections.emptyList();
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        return StreamUtil.stream(((ParameterizedType)genericType).getActualTypeArguments()).map(t -> (Class)t).collect(Collectors.toList());
    }

    @NonNull
    public static <T> Collection<T> createImplementations(@Nullable Class<T> interfaceOrSuperClass, @Nullable String packageName) {
        return StreamUtil.stream(ReflectionUtil.findImplementations(interfaceOrSuperClass, packageName)).map(implClass -> Reflect.onClass((Class)implClass).create().get()).collect(Collectors.toList());
    }

    @NonNull
    public static <T> Collection<Class<T>> findImplementations(@Nullable Class<T> interfaceOrSuperClass, @Nullable String packageName) {
        if (interfaceOrSuperClass == null) {
            return Collections.emptyList();
        }
        ScanResult scanResult = packageName != null ? new ClassGraph().enableAllInfo().whitelistPackages(new String[]{packageName}).scan() : new ClassGraph().enableAllInfo().scan();
        try (ScanResult scanResult2 = scanResult;){
            ClassInfoList implControlClasses = interfaceOrSuperClass.isInterface() ? scanResult.getClassesImplementing(interfaceOrSuperClass.getName()) : new ClassInfoList();
            ClassInfoList controlClasses = scanResult.getSubclasses(interfaceOrSuperClass.getName());
            controlClasses.addAll((Collection)implControlClasses);
            List list = controlClasses.filter(classInfo -> !classInfo.isAbstract()).loadClasses(interfaceOrSuperClass);
            return list;
        }
    }

    @NonNull
    public static Optional<Class<?>> findOneClassBySimpleNameInJdk(@Nullable String classSimpleName) {
        if (StringUtils.isBlank((CharSequence)classSimpleName)) {
            return Optional.empty();
        }
        try (ScanResult scanResult = new ClassGraph().addClassLoader(ClassLoader.getSystemClassLoader()).enableSystemJarsAndModules().whitelistPackages(new String[]{"java.lang", "java.util"}).scan();){
            ClassInfoList controlClasses = scanResult.getAllClasses();
            Optional<Class<?>> optional = controlClasses.filter(classInfo -> classSimpleName.equalsIgnoreCase(classInfo.getSimpleName())).directOnly().stream().findFirst().map(ClassInfo::loadClass);
            return optional;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

