/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import ru.iopump.qa.exception.QaUtilException;
import ru.iopump.qa.util.FileUtil;

public final class ResourceUtil {
    @NonNull
    public static InputStream getResourceAsStream(@NonNull String relativeOrAbsoluteOrClasspath) {
        if (relativeOrAbsoluteOrClasspath == null) {
            throw new NullPointerException("relativeOrAbsoluteOrClasspath is marked non-null but is null");
        }
        return ResourceUtil.ifFileFromFileSystem(relativeOrAbsoluteOrClasspath).filter(file -> Files.exists(file, new LinkOption[0])).map(file -> {
            try {
                return Files.newInputStream(file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new QaUtilException("Cannot read resource '{}'. It is a file. But cannot be read", (Throwable)e, relativeOrAbsoluteOrClasspath);
            }
        }).orElseGet(() -> Optional.ofNullable(Thread.currentThread().getContextClassLoader()).map(cl -> cl.getResourceAsStream(relativeOrAbsoluteOrClasspath)).orElseGet(() -> Optional.ofNullable(ClassLoader.getSystemResourceAsStream(relativeOrAbsoluteOrClasspath)).orElseGet(() -> Optional.ofNullable(ResourceUtil.class.getResourceAsStream(relativeOrAbsoluteOrClasspath)).orElseThrow(() -> new QaUtilException("Cannot find resource '{}'. It is not absolute path, not relative path, not classpath resource", relativeOrAbsoluteOrClasspath)))));
    }

    private static Optional<Path> ifFileFromFileSystem(String relativeOrAbsoluteOrClasspath) {
        if (FileUtil.isAbsolute(relativeOrAbsoluteOrClasspath)) {
            return Optional.of(Paths.get(relativeOrAbsoluteOrClasspath, new String[0]));
        }
        if (FileUtil.isUserDirRelative(relativeOrAbsoluteOrClasspath)) {
            return Optional.of(FileUtil.getUserDir().resolve(relativeOrAbsoluteOrClasspath));
        }
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

