/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.helpers.MessageFormatter;
import ru.iopump.qa.util.StreamUtil;

public final class Str {
    public static final Integer MAP_FORMAT_MAX_ALIGN_DEFAULT = 60;
    public static final String NULL_STR_DEFAULT = "null";
    private static String NULL_STR = "null";
    private static int MAP_FORMAT_MAX_ALIGN = MAP_FORMAT_MAX_ALIGN_DEFAULT;

    public static void setMapFormatMaxAlign(int align) {
        MAP_FORMAT_MAX_ALIGN = align;
    }

    public static void setNullStrDefault(@NonNull String nullStrDefault) {
        if (nullStrDefault == null) {
            throw new NullPointerException("nullStrDefault is marked non-null but is null");
        }
        NULL_STR = nullStrDefault;
    }

    @NonNull
    public static String nullStr() {
        return NULL_STR;
    }

    @NonNull
    public static String frm(@Nullable String slf4jMessagePattern, Object ... args) {
        return Str.format(slf4jMessagePattern, args);
    }

    @NonNull
    public static String format(@Nullable String slf4jMessagePattern, Object ... args) {
        if (slf4jMessagePattern == null) {
            return Str.nullStr();
        }
        if (ArrayUtils.isEmpty((Object[])args)) {
            return slf4jMessagePattern;
        }
        return MessageFormatter.arrayFormat((String)slf4jMessagePattern, (Object[])args).getMessage();
    }

    @NonNull
    public static <T> Optional<T> ifNotBlank(@Nullable CharSequence value, @Nullable Function<CharSequence, T> consumer) {
        return StringUtils.isNotBlank((CharSequence)value) && consumer != null ? Optional.ofNullable(consumer.apply(value)) : Optional.empty();
    }

    @NonNull
    public static String toStr(@Nullable Object object) {
        return Str.toString(object);
    }

    public static String toPrettyString(@Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Object[]) {
            return Str.toPrettyString((Object[])object);
        }
        if (object instanceof Map) {
            return Str.toPrettyString((Map)object);
        }
        if (object instanceof Iterable) {
            return Str.toPrettyString((Iterable)object);
        }
        return "Cannot pretty: " + Str.toStr(object);
    }

    public static String toPrettyString(Object ... array) {
        if (array == null) {
            return "";
        }
        return Str.toPrettyString(Arrays.asList(array));
    }

    @NonNull
    public static String toPrettyString(@Nullable Map<?, ?> map) {
        if (map == null) {
            return "";
        }
        Map<String, String> printableMap = map.keySet().stream().collect(Collectors.toMap(Str::toStr, Str::toStr));
        int maxKeyLengthTmp = printableMap.keySet().stream().map(String::length).max(Comparator.naturalOrder()).orElse(10);
        int maxKeyLengthFinal = Math.min(maxKeyLengthTmp, MAP_FORMAT_MAX_ALIGN);
        return "Size: " + map.size() + StreamUtil.stream(map).map(e -> String.format("%" + maxKeyLengthFinal + "s : %s", e.getKey(), e.getValue())).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), ""));
    }

    public static String toPrettyString(@Nullable Iterable<?> objects) {
        if (objects == null) {
            return "";
        }
        return "Size: " + Iterables.size(objects) + StreamUtil.stream(objects).map(Str::toStr).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), ""));
    }

    @NonNull
    public static String toString(@Nullable Object object) {
        if (object == null) {
            return Str.nullStr();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            if (object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                return object.toString();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (object instanceof Collection) {
            return Arrays.toString(StreamUtil.stream((Collection)object).map(Str::toString).toArray());
        }
        if (object instanceof Object[]) {
            return Arrays.toString(StreamUtil.stream((Object[])object).map(Str::toString).toArray());
        }
        return ReflectionToStringBuilder.toString((Object)object, (ToStringStyle)QaSimpleToStringStyle.INSTANCE);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Str() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class QaSimpleToStringStyle
    extends ToStringStyle {
        private static final ToStringStyle INSTANCE = new QaSimpleToStringStyle();
        private static final long serialVersionUID = 1L;

        private QaSimpleToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart("(");
            this.setContentEnd(")");
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

