/*
 * Decompiled with CFR 0.152.
 */
package ru.iopump.qa.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public final class StreamUtil {
    @SafeVarargs
    @NonNull
    public static <T> Stream<T> stream(T ... array) {
        if (array == null) {
            return Stream.empty();
        }
        return StreamUtil.stream(Arrays.asList(array));
    }

    @NonNull
    public static <T> Stream<T> stream(@Nullable Iterable<T> iterable) {
        return StreamSupport.stream(Optional.ofNullable(iterable).map(Iterable::spliterator).orElse(Spliterators.emptySpliterator()), false);
    }

    @NonNull
    public static <K, V> Stream<Map.Entry<K, V>> stream(@Nullable Map<K, V> map) {
        return StreamUtil.stream(Optional.ofNullable(map).map(Map::entrySet).get());
    }

    @NonNull
    public static <V> Stream<V> noNull(@Nullable Stream<V> stream) {
        if (stream == null) {
            return Stream.empty();
        }
        return stream.filter(Objects::nonNull);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private StreamUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

