package ru.ivk1800.riflesso

import org.jetbrains.kotlin.ir.IrElement
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction
import org.jetbrains.kotlin.ir.expressions.IrCall
import org.jetbrains.kotlin.ir.expressions.IrWhen
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid
import org.jetbrains.kotlin.name.Name

/**
 *     @Composable fun A(x: Int, $composer: Composer<*>, $changed: Int) {
 *       var $dirty = $changed
 *       if ($changed and 0b0110 == 0) {
 *         $dirty = $dirty or if ($composer.changed(x)) 0b0010 else 0b0100
 *       }
 *      if (%dirty and 0b1011 != 0b1010 || !$composer.skipping) {
 *        f(x)
 *      } else {
 *        $composer.skipToGroupEnd()
 *      }
 *     }
 */
class ComposableSkippingFinder private constructor() : IrElementVisitorVoid {
    private val irElementStack = ArrayDeque<IrElement>()
    private var result: Pair<IrCall, List<IrElement>>? = null

    override fun visitElement(element: IrElement) {
        irElementStack.addLast(element)
        element.acceptChildren(this, null)
        irElementStack.removeLast()
    }

    private val skipToGroupEndName = Name.identifier("skipToGroupEnd")

    override fun visitCall(expression: IrCall) {
        val calledName = expression.symbol.owner.name
        if (calledName == skipToGroupEndName) {
            result = expression to irElementStack.toList()
        }
    }

    companion object {
        fun find(function: IrSimpleFunction): IrWhen? {
            val visitor = ComposableSkippingFinder()
            function.accept(visitor, null)

            return visitor.result?.second?.lastOrNull { it is IrWhen } as? IrWhen
        }
    }
}
