package ru.ivk1800.riflesso

import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption
import org.jetbrains.kotlin.compiler.plugin.CliOption
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor
import org.jetbrains.kotlin.compiler.plugin.ExperimentalCompilerApi
import org.jetbrains.kotlin.config.CompilerConfiguration

@OptIn(ExperimentalCompilerApi::class)
@Suppress("unused") // Used via reflection.
class RiflessoCommandLineProcessor : CommandLineProcessor {
    override val pluginId: String = BuildConfig.KOTLIN_PLUGIN_ID

    override val pluginOptions: Collection<CliOption> = listOf(IS_ENABLED)

    override fun processOption(option: AbstractCliOption, value: String, configuration: CompilerConfiguration) {
        when(option) {
            IS_ENABLED -> configuration.put(PluginKeys.IS_ENABLED, value.toBoolean())
            else -> throw IllegalArgumentException("Unknown option $option")
        }
    }

    companion object {
        val IS_ENABLED = CliOption("isEnabled", "<bool>", "Option 4", required = false)
    }
}
